/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.DGMMemberContributor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class GDKSuperMethodSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super MethodSignatureBackedByPsiMethod> consumer) {
        PsiMethod m;
        PsiMethod method = queryParameters.getMethod();
        if (!(method instanceof GrMethod)) {
            return true;
        }
        if (method.hasModifierProperty("static")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        HierarchicalMethodSignature hierarchicalSignature = method.getHierarchicalMethodSignature();
        if (!hierarchicalSignature.getSuperSignatures().isEmpty()) {
            return true;
        }
        Project project = method.getProject();
        String name = method.getName();
        MethodResolverProcessor processor = new MethodResolverProcessor(name, (PsiElement)method, false, null, null, PsiType.EMPTY_ARRAY);
        DGMMemberContributor.processDgmMethods((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(psiClass), processor, (PsiElement)method, ResolveState.initial());
        GroovyResolveResult[] candidates = processor.getCandidates();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        ArrayList<PsiMethod> goodSupers = new ArrayList<PsiMethod>();
        for (GroovyResolveResult candidate : candidates) {
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod) || GDKSuperMethodSearcher.isTheSameMethod(method, psiManager, m = (PsiMethod)element) || !PsiImplUtil.isExtendsSignature((MethodSignature)m.getHierarchicalMethodSignature(), (MethodSignature)signature)) continue;
            goodSupers.add(m);
        }
        if (goodSupers.isEmpty()) {
            return true;
        }
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>(goodSupers.size());
        result2.add((PsiMethod)goodSupers.get(0));
        Comparator comparator2 = (o1, o2) -> {
            PsiType type2;
            PsiType type1 = GDKSuperMethodSearcher.getRealType(o1);
            if (TypesUtil.isAssignableByMethodCallConversion(type1, type2 = GDKSuperMethodSearcher.getRealType(o2), (PsiElement)o1)) {
                return -1;
            }
            if (TypesUtil.isAssignableByMethodCallConversion(type2, type1, (PsiElement)o1)) {
                return 1;
            }
            return 0;
        };
        block1: for (PsiMethod current : goodSupers) {
            Iterator i = result2.iterator();
            while (i.hasNext()) {
                m = (PsiMethod)i.next();
                int res = comparator2.compare(m, current);
                if (res > 0) continue block1;
                if (res >= 0) continue;
                i.remove();
            }
            result2.add(current);
        }
        for (PsiMethod psiMethod : result2) {
            if (consumer.process((Object)GDKSuperMethodSearcher.getRealMethod(psiMethod).getHierarchicalMethodSignature())) continue;
            return false;
        }
        return true;
    }

    private static boolean isTheSameMethod(PsiMethod method, PsiManager psiManager, PsiMethod m) {
        return psiManager.areElementsEquivalent((PsiElement)m, (PsiElement)method) || psiManager.areElementsEquivalent(m.getNavigationElement(), (PsiElement)method);
    }

    private static PsiMethod getRealMethod(PsiMethod method) {
        PsiElement element = method.getNavigationElement();
        if (element instanceof PsiMethod && !((PsiMethod)element).getParameterList().isEmpty()) {
            return (PsiMethod)element;
        }
        return method;
    }

    @Nullable
    private static PsiType getRealType(PsiMethod method) {
        PsiParameter[] parameters2;
        PsiElement navigationElement = method.getNavigationElement();
        if (navigationElement instanceof PsiMethod && (parameters2 = ((PsiMethod)navigationElement).getParameterList().getParameters()).length != 0) {
            return TypeConversionUtil.erasure((PsiType)parameters2[0].getType());
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(containingClass);
    }
}

