/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\bH\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\f\u001a\f\u0010\r\u001a\u00020\n*\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\u0004H\u0002\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\fH\u0002\u001a\f\u0010\u0010\u001a\u00020\n*\u00020\u000eH\u0002\u001a\f\u0010\u0011\u001a\u00020\n*\u00020\u000eH\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"AND_LABEL", "", "WHERE_LABEL", "findWhereLabeledStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "top", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrLabeledStatement;", "findMaybeTableRow", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "isOr", "", "isTableColumnSeparator", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isTableHeader", "Lcom/intellij/psi/PsiElement;", "isTableRow", "isUnderTableHeader", "maybeTableColumnExpression", "intellij.groovy.psi"})
public final class DataTablesKt {
    @NlsSafe
    private static final String WHERE_LABEL = "where";
    @NlsSafe
    private static final String AND_LABEL = "and";

    public static final boolean isTableColumnSeparator(@NotNull GrExpression $this$isTableColumnSeparator) {
        if (!($this$isTableColumnSeparator instanceof GrBinaryExpression) || !DataTablesKt.isOr((GrBinaryExpression)$this$isTableColumnSeparator)) {
            return false;
        }
        GrBinaryExpression grBinaryExpression = DataTablesKt.findMaybeTableRow((GrBinaryExpression)$this$isTableColumnSeparator);
        if (grBinaryExpression == null) {
            return false;
        }
        GrBinaryExpression maybeTableRow = grBinaryExpression;
        return DataTablesKt.isUnderTableHeader(maybeTableRow) || DataTablesKt.isTableRow(maybeTableRow);
    }

    private static final GrBinaryExpression findMaybeTableRow(GrBinaryExpression $this$findMaybeTableRow) {
        GrBinaryExpression current = $this$findMaybeTableRow;
        while (true) {
            PsiElement parent2;
            if ((parent2 = current.getParent()) == null) {
                return null;
            }
            if (!(parent2 instanceof GrBinaryExpression) || !DataTablesKt.isOr((GrBinaryExpression)parent2)) break;
            current = (GrBinaryExpression)parent2;
        }
        return current;
    }

    private static final boolean isUnderTableHeader(PsiElement $this$isUnderTableHeader) {
        PsiElement psiElement = $this$isUnderTableHeader.getParent();
        return psiElement != null ? DataTablesKt.isTableHeader(psiElement) : false;
    }

    private static final boolean isTableHeader(PsiElement $this$isTableHeader) {
        return $this$isTableHeader instanceof GrLabeledStatement && Intrinsics.areEqual((Object)((GrLabeledStatement)$this$isTableHeader).getName(), (Object)WHERE_LABEL);
    }

    private static final boolean isTableRow(GrExpression $this$isTableRow) {
        PsiElement parent2 = $this$isTableRow.getParent();
        if (parent2 instanceof GrLabeledStatement && Intrinsics.areEqual((Object)((GrLabeledStatement)parent2).getName(), (Object)AND_LABEL)) {
            return DataTablesKt.isTableRow((GrStatement)parent2);
        }
        GrExpression grExpression = $this$isTableRow;
        if (grExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement");
        }
        return DataTablesKt.isTableRow((GrStatement)grExpression);
    }

    private static final boolean isTableRow(GrStatement $this$isTableRow) {
        for (PsiElement sibling : PsiTreeUtilKt.skipTokens((Sequence)SequencesKt.drop((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)$this$isTableRow, (boolean)false, (boolean)false, (int)2, null), (int)1), (TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS)) {
            if (DataTablesKt.maybeTableColumnExpression(sibling)) continue;
            if (!(sibling instanceof GrLabeledStatement)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((GrLabeledStatement)sibling).getName(), (Object)AND_LABEL)) {
                GrStatement grStatement = ((GrLabeledStatement)sibling).getStatement();
                if (grStatement != null) {
                    if (DataTablesKt.maybeTableColumnExpression(grStatement)) {
                        continue;
                    }
                }
            }
            return DataTablesKt.findWhereLabeledStatement((GrLabeledStatement)sibling) != null;
        }
        return false;
    }

    @Nullable
    public static final GrStatement findWhereLabeledStatement(@NotNull GrLabeledStatement top) {
        GrLabeledStatement current = top;
        while (true) {
            GrStatement labeledStatement = current.getStatement();
            if (Intrinsics.areEqual((Object)WHERE_LABEL, (Object)current.getName())) {
                return labeledStatement;
            }
            if (!(labeledStatement instanceof GrLabeledStatement)) break;
            current = (GrLabeledStatement)labeledStatement;
        }
        return null;
    }

    private static final boolean maybeTableColumnExpression(PsiElement $this$maybeTableColumnExpression) {
        return $this$maybeTableColumnExpression instanceof GrBinaryExpression && DataTablesKt.isOr((GrBinaryExpression)$this$maybeTableColumnExpression);
    }

    public static final boolean isOr(@NotNull GrBinaryExpression $this$isOr) {
        IElementType type2 = $this$isOr.getOperationTokenType();
        return type2 == GroovyElementTypes.T_BOR || type2 == GroovyElementTypes.T_LOR;
    }
}

