/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStatementMover
extends StatementUpDownMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Project project = file.getProject();
        if (!HandlerUtils.canBeInvoked(editor, project) || !(file instanceof GroovyFileBase)) {
            return false;
        }
        LineRange range = GroovyStatementMover.getLineRangeFromSelection((Editor)editor);
        Document document = editor.getDocument();
        int offset = document.getLineStartOffset(range.startLine);
        GrLiteral literal = (GrLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, GrLiteral.class, (boolean)false);
        if (literal != null && literal.textContains('\n')) {
            return false;
        }
        GroovyPsiElement pivot = GroovyStatementMover.getElementToMove((GroovyFileBase)file, offset);
        if (pivot == null) {
            return false;
        }
        LineRange pivotRange = GroovyStatementMover.getLineRange(pivot);
        range = new LineRange(Math.min(range.startLine, pivotRange.startLine), Math.max(range.endLine, pivotRange.endLine));
        GroovyPsiElement scope = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)pivot, (Class[])new Class[]{GrMethod.class, GrTypeDefinitionBody.class, GroovyFileBase.class});
        boolean stmtLevel = GroovyStatementMover.isStatement(pivot);
        boolean topLevel = pivot instanceof GrTypeDefinition && pivot.getParent() instanceof GroovyFileBase;
        List<LineRange> allRanges = this.allRanges(scope, stmtLevel, topLevel);
        LineRange prev = null;
        LineRange next = null;
        for (LineRange each : allRanges) {
            if (each.endLine <= range.startLine) {
                prev = each;
            }
            if (each.containsLine(range.startLine)) {
                range = new LineRange(each.startLine, range.endLine);
            }
            if (each.startLine < range.endLine && each.endLine > range.endLine) {
                range = new LineRange(range.startLine, each.endLine);
            }
            if (each.startLine < range.endLine || next != null) continue;
            next = each;
        }
        info.toMove = range;
        info.toMove2 = down ? next : prev;
        return true;
    }

    @Nullable
    private static GroovyPsiElement getElementToMove(GroovyFileBase file, int offset) {
        GrDocCommentOwner owner;
        offset = CharArrayUtil.shiftForward((CharSequence)file.getText(), (int)offset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, GrDocComment.class);
        if (docComment != null && (owner = docComment.getOwner()) != null) {
            element = owner;
        }
        if (element instanceof PsiComment) {
            element = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        }
        return (GroovyPsiElement)PsiTreeUtil.findFirstParent((PsiElement)element, element11 -> GroovyStatementMover.isMovable(element11));
    }

    private List<LineRange> allRanges(GroovyPsiElement scope, final boolean stmtLevel, final boolean topLevel) {
        final ArrayList<LineRange> result2 = new ArrayList<LineRange>();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            int lastStart = -1;

            private void addRange(int endLine) {
                if (this.lastStart >= 0) {
                    result2.add(new LineRange(this.lastStart, endLine));
                }
                this.lastStart = endLine;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (stmtLevel && element instanceof GrCodeBlock) {
                    PsiElement lBrace = ((GrCodeBlock)element).getLBrace();
                    if (GroovyStatementMover.nlsAfter(lBrace)) {
                        this.addRange(new LineRange((PsiElement)lBrace).endLine);
                    }
                    this.addChildRanges(((GrCodeBlock)element).getStatements());
                    PsiElement rBrace = ((GrCodeBlock)element).getRBrace();
                    if (GroovyStatementMover.nlsAfter(rBrace)) {
                        int endLine = new LineRange((PsiElement)rBrace).endLine;
                        if (this.lastStart >= 0) {
                            for (int i = this.lastStart + 1; i < endLine; ++i) {
                                this.addRange(i);
                            }
                        }
                    }
                } else if (stmtLevel && element instanceof GrCaseSection) {
                    PsiElement delimiter = ((GrCaseSection)element).getColon();
                    if (delimiter != null) {
                        if (GroovyStatementMover.nlsAfter(delimiter)) {
                            this.addRange(new LineRange((PsiElement)element.getFirstChild(), (PsiElement)delimiter).endLine);
                        }
                        this.addChildRanges(((GrCaseSection)element).getStatements());
                    } else {
                        GrStatement[] statements2 = ((GrCaseSection)element).getStatements();
                        if (statements2.length == 1 && statements2[0] instanceof GrBlockStatement) {
                            GrOpenBlock block = ((GrBlockStatement)statements2[0]).getBlock();
                            if (GroovyStatementMover.nlsAfter(block.getLBrace())) {
                                this.addRange(new LineRange((PsiElement)element.getFirstChild(), (PsiElement)block.getLBrace()).endLine);
                            }
                            this.addChildRanges(block.getStatements());
                        }
                    }
                } else if (element instanceof GroovyFileBase) {
                    this.addChildRanges(((GroovyFileBase)element).getTopStatements());
                } else if (!stmtLevel && !topLevel && element instanceof GrTypeDefinitionBody) {
                    this.addChildRanges(((GrTypeDefinitionBody)element).getMemberDeclarations());
                } else {
                    super.visitElement(element);
                }
            }

            private boolean shouldDigInside(GroovyPsiElement statement) {
                if (stmtLevel && (statement instanceof GrMethod || statement instanceof GrTypeDefinition)) {
                    return false;
                }
                return !(statement instanceof GrVariableDeclaration) || stmtLevel;
            }

            private void addChildRanges(GroovyPsiElement[] statements2) {
                for (int i = 0; i < statements2.length; ++i) {
                    GroovyPsiElement statement = statements2[i];
                    if (!GroovyStatementMover.nlsAfter(statement)) continue;
                    LineRange range = GroovyStatementMover.getLineRange(statement);
                    if ((i == 0 || GroovyStatementMover.isStatement(statements2[i - 1])) && GroovyStatementMover.isStatement(statement)) {
                        for (int j = this.lastStart; j < range.startLine; ++j) {
                            this.addRange(j + 1);
                        }
                    }
                    this.lastStart = range.startLine;
                    if (this.shouldDigInside(statement)) {
                        statement.accept((PsiElementVisitor)this);
                    }
                    this.addRange(range.endLine);
                }
            }
        });
        return result2;
    }

    private static boolean nlsAfter(@Nullable PsiElement element) {
        String text;
        if (element == null) {
            return false;
        }
        PsiElement sibling = element;
        do {
            if ((sibling = PsiTreeUtil.nextLeaf((PsiElement)sibling)) == null) {
                return true;
            }
            text = sibling.getText();
            if (!text.contains("\n")) continue;
            return text.charAt(CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t")) == '\n';
        } while (sibling instanceof PsiComment || StringUtil.isEmptyOrSpaces((String)text) || text.equals(";"));
        return false;
    }

    private static boolean isMovable(PsiElement element) {
        return GroovyStatementMover.isStatement(element) || GroovyStatementMover.isMemberDeclaration(element);
    }

    private static boolean isMemberDeclaration(PsiElement element) {
        return element instanceof GrMembersDeclaration || element instanceof GrTypeDefinition;
    }

    private static boolean isStatement(PsiElement element) {
        return element instanceof GrStatement && PsiUtil.isExpressionStatement(element);
    }

    private static LineRange getLineRange(GroovyPsiElement pivot) {
        GrDocComment comment;
        GrVariable variable;
        GrVariable[] variables;
        if (pivot instanceof GrDocCommentOwner) {
            GrDocComment comment2 = ((GrDocCommentOwner)pivot).getDocComment();
            if (comment2 != null) {
                return new LineRange((PsiElement)comment2, (PsiElement)pivot);
            }
        } else if (pivot instanceof GrVariableDeclaration && pivot.getParent() instanceof GrTypeDefinitionBody && (variables = ((GrVariableDeclaration)pivot).getVariables()).length > 0 && (variable = variables[0]) instanceof GrField && (comment = ((GrField)variable).getDocComment()) != null) {
            return new LineRange((PsiElement)comment, (PsiElement)pivot);
        }
        return new LineRange((PsiElement)pivot);
    }
}

