/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.editor.actions.GroovyTypedHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean myToDeleteGt;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        int offset = editor.getCaretModel().getOffset() - 1;
        this.myToDeleteGt = c == '<' && file instanceof GroovyFile && GroovyTypedHandler.isAfterClassLikeIdentifier(offset, editor);
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence chars2 = editor.getDocument().getCharsSequence();
        if (editor.getDocument().getTextLength() <= offset) {
            return false;
        }
        char c1 = chars2.charAt(offset);
        if (c == '<' && this.myToDeleteGt) {
            if (c1 != '>') {
                return true;
            }
            TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)GroovyTokenTypes.mLT, (IElementType)GroovyTokenTypes.mGT, (TokenSet)GroovyTypedHandler.INVALID_INSIDE_REFERENCE);
            return true;
        }
        return false;
    }
}

