/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyImportUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyImportOptimizer
implements ImportOptimizer {
    public static Comparator<GrImportStatement> getComparator(GroovyCodeStyleSettings settings) {
        return (statement1, statement2) -> {
            if (settings.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
                if (statement1.isStatic() && !statement2.isStatic()) {
                    return 1;
                }
                if (statement2.isStatic() && !statement1.isStatic()) {
                    return -1;
                }
            }
            String name1 = statement1.getImportFqn();
            String name2 = statement2.getImportFqn();
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        };
    }

    public boolean supports(@NotNull PsiFile file) {
        return file instanceof GroovyFile;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        return new MyProcessor((GroovyFile)file).compute();
    }

    private static final class MyProcessor
    implements NotNullComputable<Runnable> {
        private final GroovyFile myFile;

        private MyProcessor(@NotNull GroovyFile file) {
            this.myFile = file;
        }

        @NotNull
        public Runnable compute() {
            LinkedHashSet<String> simplyImportedClasses = new LinkedHashSet<String>();
            LinkedHashSet<String> staticallyImportedMembers = new LinkedHashSet<String>();
            HashSet<GrImportStatement> usedImports = new HashSet<GrImportStatement>();
            HashSet<GrImportStatement> unresolvedOnDemandImports = new HashSet<GrImportStatement>();
            LinkedHashSet<String> implicitlyImportedClasses = new LinkedHashSet<String>();
            HashSet<String> innerClasses = new HashSet<String>();
            HashMap<String, String> aliasImported = new HashMap<String, String>();
            HashMap<String, String> annotatedImports = new HashMap<String, String>();
            GroovyImportUtil.processFile(this.myFile, simplyImportedClasses, staticallyImportedMembers, usedImports, unresolvedOnDemandImports, implicitlyImportedClasses, innerClasses, aliasImported, annotatedImports);
            List<GrImportStatement> oldImports = PsiUtil.getValidImportStatements(this.myFile);
            GrImportStatement[] newImports = this.prepare(usedImports, simplyImportedClasses, staticallyImportedMembers, implicitlyImportedClasses, innerClasses, aliasImported, annotatedImports, unresolvedOnDemandImports);
            if (oldImports.isEmpty() && newImports.length == 0 && aliasImported.isEmpty()) {
                return EmptyRunnable.getInstance();
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myFile.getProject());
            GroovyFile tempFile = factory.createGroovyFile("", false, null);
            tempFile.putUserData(PsiFileFactory.ORIGINAL_FILE, this.myFile);
            for (GrImportStatement newImport : newImports) {
                tempFile.addImport(newImport);
            }
            if (!oldImports.isEmpty()) {
                int startOffset = oldImports.get(0).getTextRange().getStartOffset();
                int endOffset = oldImports.get(oldImports.size() - 1).getTextRange().getEndOffset();
                String oldText = this.myFile.getText().substring(startOffset, endOffset);
                if (tempFile.getText().trim().equals(oldText)) {
                    return EmptyRunnable.getInstance();
                }
            }
            return () -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myFile.getProject());
                Document document = documentManager.getDocument((PsiFile)this.myFile);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
                List<GrImportStatement> existingImports = PsiUtil.getValidImportStatements(this.myFile);
                for (GrImportStatement statement : tempFile.getImportStatements()) {
                    this.myFile.addImport(statement);
                }
                for (GrImportStatement importStatement : existingImports) {
                    this.myFile.removeImport(importStatement);
                }
            };
        }

        private GrImportStatement[] prepare(Set<GrImportStatement> usedImports, Set<String> importedClasses, Set<String> staticallyImportedMembers, Set<String> implicitlyImported, Set<String> innerClasses, Map<String, String> aliased, Map<String, String> annotations2, Set<GrImportStatement> unresolvedOnDemandImports) {
            Project project = this.myFile.getProject();
            GroovyCodeStyleSettings settings = GroovyCodeStyleSettings.getInstance(this.myFile);
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            Object2IntOpenHashMap packageCountMap = new Object2IntOpenHashMap();
            Object2IntOpenHashMap classCountMap = new Object2IntOpenHashMap();
            for (String importedClass : importedClasses) {
                if (implicitlyImported.contains(importedClass) || innerClasses.contains(importedClass) || aliased.containsKey(importedClass) || annotations2.containsKey(importedClass)) continue;
                String packageName = StringUtil.getPackageName((String)importedClass);
                packageCountMap.mergeInt((Object)packageName, 1, Math::addExact);
            }
            for (String importedMember : staticallyImportedMembers) {
                if (aliased.containsKey(importedMember) || annotations2.containsKey(importedMember)) continue;
                classCountMap.mergeInt((Object)StringUtil.getPackageName((String)importedMember), 1, Math::addExact);
            }
            HashSet<String> onDemandImportedSimpleClassNames = new HashSet<String>();
            ArrayList<GrImportStatement> result2 = new ArrayList<GrImportStatement>();
            for (Object entry : packageCountMap.object2IntEntrySet()) {
                String s = (String)entry.getKey();
                if (entry.getIntValue() < settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND && !settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(s)) continue;
                GrImportStatement imp = factory.createImportStatementFromText(s, false, true, null);
                String annos = annotations2.remove(s + ".*");
                if (annos != null) {
                    imp.getAnnotationList().replace(factory.createModifierList(annos));
                }
                result2.add(imp);
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myFile.getProject()).findPackage(s);
                if (aPackage == null) continue;
                for (PsiClass clazz : aPackage.getClasses(this.myFile.getResolveScope())) {
                    onDemandImportedSimpleClassNames.add(clazz.getName());
                }
            }
            for (Object entry : classCountMap.object2IntEntrySet()) {
                if (entry.getIntValue() < settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) continue;
                GrImportStatement imp = factory.createImportStatementFromText((String)entry.getKey(), true, true, null);
                String annos = annotations2.remove((String)entry.getKey() + ".*");
                if (annos != null) {
                    imp.getAnnotationList().replace(factory.createModifierList(annos));
                }
                result2.add(imp);
            }
            ArrayList<GrImportStatement> explicated = new ArrayList<GrImportStatement>();
            for (String importedClass : importedClasses) {
                String parentName = StringUtil.getPackageName((String)importedClass);
                if (!annotations2.containsKey(importedClass) && !aliased.containsKey(importedClass) && (packageCountMap.getInt((Object)parentName) >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND || settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(parentName) || implicitlyImported.contains(importedClass) && !onDemandImportedSimpleClassNames.contains(StringUtil.getShortName((String)importedClass)))) continue;
                GrImportStatement imp = factory.createImportStatementFromText(importedClass, false, false, null);
                String annos = annotations2.remove(importedClass);
                if (annos != null) {
                    imp.getAnnotationList().replace(factory.createModifierList(annos));
                }
                explicated.add(imp);
            }
            for (String importedMember : staticallyImportedMembers) {
                String className = StringUtil.getPackageName((String)importedMember);
                if (!annotations2.containsKey(importedMember) && !aliased.containsKey(importedMember) && classCountMap.getInt((Object)className) >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) continue;
                result2.add(factory.createImportStatementFromText(importedMember, true, false, null));
            }
            for (GrImportStatement anImport : usedImports) {
                if (!anImport.isAliasedImport() && !GroovyImportUtil.isAnnotatedImport(anImport)) continue;
                if (GroovyImportUtil.isAnnotatedImport(anImport)) {
                    annotations2.remove(anImport.getImportFqn());
                }
                if (anImport.isStatic()) {
                    result2.add(anImport);
                    continue;
                }
                explicated.add(anImport);
            }
            Comparator<GrImportStatement> comparator2 = GroovyImportOptimizer.getComparator(settings);
            result2.sort(comparator2);
            explicated.sort(comparator2);
            explicated.addAll(result2);
            if (!annotations2.isEmpty()) {
                StringBuilder allSkippedAnnotations = new StringBuilder();
                for (String anno : annotations2.values()) {
                    allSkippedAnnotations.append(anno).append(' ');
                }
                if (explicated.isEmpty()) {
                    explicated.add(factory.createImportStatementFromText("java.lang.Object", false, false, null));
                }
                GrImportStatement first = (GrImportStatement)explicated.get(0);
                allSkippedAnnotations.append(first.getAnnotationList().getText());
                first.getAnnotationList().replace(factory.createModifierList(allSkippedAnnotations));
            }
            explicated.addAll(unresolvedOnDemandImports);
            return explicated.toArray(GrImportStatement.EMPTY_ARRAY);
        }
    }
}

