/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CompoundMembersHolder;

public interface CustomMembersHolder {
    public static final CustomMembersHolder EMPTY = new CustomMembersHolder(){

        @Override
        public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
            return true;
        }

        @Override
        public void consumeClosureDescriptors(GroovyClassDescriptor descriptor, Consumer<? super ClosureDescriptor> consumer) {
        }
    };

    public boolean processMembers(GroovyClassDescriptor var1, PsiScopeProcessor var2, ResolveState var3);

    public void consumeClosureDescriptors(GroovyClassDescriptor var1, Consumer<? super ClosureDescriptor> var2);

    @NotNull
    public static CustomMembersHolder create(@NotNull List<CustomMembersHolder> holders) {
        List nonEmptyHolders = ContainerUtil.filter(holders, it -> it != EMPTY);
        if (nonEmptyHolders.isEmpty()) {
            return EMPTY;
        }
        if (nonEmptyHolders.size() == 1) {
            return (CustomMembersHolder)nonEmptyHolders.get(0);
        }
        return new CompoundMembersHolder(nonEmptyHolders);
    }
}

