/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;

class CompoundMembersHolder
implements CustomMembersHolder {
    private final List<CustomMembersHolder> myHolders;

    CompoundMembersHolder(@NotNull List<CustomMembersHolder> holders) {
        this.myHolders = new ArrayList<CustomMembersHolder>(holders);
    }

    @Override
    public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
        for (CustomMembersHolder holder : this.myHolders) {
            if (holder.processMembers(descriptor, processor, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void consumeClosureDescriptors(GroovyClassDescriptor descriptor, Consumer<? super ClosureDescriptor> consumer) {
        for (CustomMembersHolder holder : this.myHolders) {
            holder.consumeClosureDescriptors(descriptor, consumer);
        }
    }
}

