/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import groovy.lang.Closure;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.DslErrorReporter;
import org.jetbrains.plugins.groovy.dsl.FactorTree;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class GroovyDslScript {
    private static final Logger LOG = Logger.getInstance(GroovyDslScript.class);
    private final Project project;
    @Nullable
    private final VirtualFile file;
    private final GroovyDslExecutor executor;
    private final String myPath;
    private final FactorTree myFactorTree;

    public GroovyDslScript(Project project, @Nullable VirtualFile file, @NotNull GroovyDslExecutor executor, String path) {
        this.project = project;
        this.file = file;
        this.executor = executor;
        this.myPath = path;
        this.myFactorTree = new FactorTree(project, executor);
    }

    @NotNull
    public CustomMembersHolder processExecutor(@NotNull GroovyClassDescriptor descriptor) {
        CustomMembersHolder holder = this.myFactorTree.retrieve(descriptor);
        try {
            if (holder == null) {
                holder = this.addGdslMembers(descriptor);
                this.myFactorTree.cache(descriptor, holder);
            }
            return holder;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleDslError(e);
            return CustomMembersHolder.EMPTY;
        }
    }

    private CustomMembersHolder addGdslMembers(@NotNull GroovyClassDescriptor descriptor) {
        ProcessingContext ctx = new ProcessingContext();
        ctx.put(GdslUtil.INITIAL_CONTEXT, (Object)descriptor);
        try {
            if (!GroovyDslScript.isApplicable(this.executor, descriptor, ctx)) {
                return CustomMembersHolder.EMPTY;
            }
            return this.executor.processVariants(descriptor, ctx);
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)cause;
            }
            if (cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            this.handleDslError(e);
        }
        catch (ProcessCanceledException | OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleDslError(e);
        }
        return CustomMembersHolder.EMPTY;
    }

    private static boolean isApplicable(@NotNull GroovyDslExecutor executor, GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        List<Pair<ContextFilter, Closure>> enhancers = executor.getEnhancers();
        if (enhancers == null) {
            LOG.error("null enhancers");
            return false;
        }
        for (Pair<ContextFilter, Closure> pair : enhancers) {
            if (!((ContextFilter)pair.first).isApplicable(descriptor, ctx)) continue;
            return true;
        }
        return false;
    }

    public void handleDslError(Throwable e) {
        if (this.project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(e);
        }
        if (this.file != null) {
            DslErrorReporter.getInstance().invokeDslErrorPopup(e, this.project, this.file);
        } else {
            LOG.info("Error when executing internal GDSL " + this.myPath, e);
            GdslUtil.stopGdsl();
        }
    }

    @Nullable
    public VirtualFile getFile() {
        return this.file;
    }

    @NonNls
    public String toString() {
        return "GroovyDslScript: " + this.myPath;
    }

    @NotNull
    public MultiMap getStaticInfo() {
        return this.executor.getStaticInfo();
    }
}

