/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;

final class ConfigureGroovyLibraryNotificationProvider
implements EditorNotificationProvider {
    ConfigureGroovyLibraryNotificationProvider() {
    }

    @NotNull
    public @NotNull Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        try {
            if (!file.getFileType().equals((Object)GroovyFileType.GROOVY_FILE_TYPE)) {
                return CONST_NULL;
            }
            if (StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle") || CompilerManager.getInstance((Project)project).isExcludedFromCompilation(file)) {
                return CONST_NULL;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null || ConfigureGroovyLibraryNotificationProvider.isMavenModule(module)) {
                return CONST_NULL;
            }
            for (GroovyFrameworkConfigNotification configNotification : (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions()) {
                if (!configNotification.hasFrameworkStructure(module)) continue;
                return configNotification.hasFrameworkLibrary(module) ? CONST_NULL : fileEditor -> ConfigureGroovyLibraryNotificationProvider.createConfigureNotificationPanel(module, fileEditor);
            }
            return CONST_NULL;
        }
        catch (ProcessCanceledException | IndexNotReadyException ignored) {
            return CONST_NULL;
        }
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createConfigureNotificationPanel(@NotNull Module module, @NotNull FileEditor fileEditor) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        panel2.setText(GroovyBundle.message("groovy.library.is.not.configured.for.module", module.getName()));
        panel2.createActionLabel(GroovyBundle.message("configure.groovy.library", new Object[0]), () -> AddCustomLibraryDialog.createDialog((CustomLibraryDescription)new GroovyLibraryDescription(), (Module)module, null).show());
        return panel2;
    }

    private static boolean isMavenModule(@NotNull Module module) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (root.findChild("pom.xml") == null) continue;
            return true;
        }
        return false;
    }
}

