/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;

public class ExcludeFromStubGenerationAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file != null && file.getLanguage() == GroovyLanguage.INSTANCE);
        ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(file);
    }

    public static void doExcludeFromStubGeneration(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        Project project = file.getProject();
        GroovyCompilerConfigurable configurable = new GroovyCompilerConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> configurable.getExcludes().addEntry(new ExcludeEntryDescription(virtualFile, false, true, (Disposable)project)));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean enabled = ExcludeFromStubGenerationAction.isEnabled(e);
        presentation.setEnabledAndVisible(enabled);
    }

    private static boolean isEnabled(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file == null || file.getLanguage() != GroovyLanguage.INSTANCE) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && !GroovyCompilerConfiguration.getExcludeConfiguration(file.getProject()).isExcluded(virtualFile);
    }
}

