/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;

public class GroovyDuplicateSwitchBranchInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.duplicate.switch.case.ref", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        private void visitSwitchElement(@NotNull GrSwitchElement switchElement) {
            HashSet<GrExpression> duplicateExpressions = new HashSet<GrExpression>();
            GrCaseSection[] sections = switchElement.getCaseSections();
            ArrayList<GrExpression> allMatchingExpressions = new ArrayList<GrExpression>(sections.length);
            for (GrCaseSection label : sections) {
                GrExpression[] expressions = label.getExpressions();
                allMatchingExpressions.addAll(Arrays.asList(expressions));
            }
            for (int i = 0; i < allMatchingExpressions.size(); ++i) {
                for (int j = i + 1; j < allMatchingExpressions.size(); ++j) {
                    if (!EquivalenceChecker.expressionsAreEquivalent((GrExpression)allMatchingExpressions.get(i), (GrExpression)allMatchingExpressions.get(j))) continue;
                    duplicateExpressions.add((GrExpression)allMatchingExpressions.get(i));
                    duplicateExpressions.add((GrExpression)allMatchingExpressions.get(j));
                }
            }
            for (GrExpression duplicateExpression : duplicateExpressions) {
                this.registerError(duplicateExpression);
            }
        }

        @Override
        public void visitSwitchExpression(@NotNull GrSwitchExpression switchExpression) {
            super.visitSwitchExpression(switchExpression);
            this.visitSwitchElement(switchExpression);
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement grSwitchStatement) {
            super.visitSwitchStatement(grSwitchStatement);
            this.visitSwitchElement(grSwitchStatement);
        }
    }
}

