/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.FileTypeInspectionDisablerKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a*\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0000\u00a8\u0006\u000e"}, d2={"checkInspectionEnabledByFileType", "", "tool", "Lcom/intellij/codeInspection/LocalInspectionTool;", "element", "Lcom/intellij/psi/PsiElement;", "explicitlyAllowedFileTypes", "", "", "enhanceInspectionToolPanel", "Ljavax/swing/JComponent;", "container", "", "actualPanel", "intellij.groovy.psi"})
@JvmName(name="GrInspectionUIUtil")
public final class GrInspectionUIUtil {
    @Nullable
    public static final JComponent enhanceInspectionToolPanel(@NotNull LocalInspectionTool tool, @NotNull Set<String> container, @Nullable JComponent actualPanel) {
        Set<FileType> disableableFileTypes = FileTypeInspectionDisablerKt.getDisableableFileTypes(tool.getClass());
        if (actualPanel == null && disableableFileTypes.isEmpty()) {
            return null;
        }
        JComponent jComponent = actualPanel;
        if (jComponent == null) {
            jComponent = (JComponent)new MultipleCheckboxOptionsPanel((InspectionProfileEntry)tool);
        }
        JComponent component = jComponent;
        Collection collection = disableableFileTypes;
        if (!collection.isEmpty()) {
            component.add((Component)SeparatorFactory.createSeparator((String)GroovyBundle.message("inspection.separator.disable.in.file.types", new Object[0]), null));
            for (FileType fileType : disableableFileTypes) {
                JBCheckBox checkBox = new JBCheckBox(fileType.getDisplayName(), container.contains(fileType.getName()));
                component.add((Component)checkBox);
                checkBox.addItemListener(new ItemListener(container, fileType){
                    final /* synthetic */ Set $container;
                    final /* synthetic */ FileType $fileType;

                    public final void itemStateChanged(ItemEvent event) {
                        if (event.getStateChange() == 1) {
                            this.$container.add(this.$fileType.getName());
                        } else {
                            this.$container.remove(this.$fileType.getName());
                        }
                    }
                    {
                        this.$container = set;
                        this.$fileType = fileType;
                    }
                });
            }
        }
        return component;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkInspectionEnabledByFileType(@NotNull LocalInspectionTool tool, @NotNull PsiElement element, @NotNull Set<String> explicitlyAllowedFileTypes) {
        void $this$filterTo$iv$iv;
        Set<FileType> disableableFileTypes = FileTypeInspectionDisablerKt.getDisableableFileTypes(tool.getClass());
        if (disableableFileTypes.isEmpty()) {
            return true;
        }
        Iterable $this$filter$iv = disableableFileTypes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType it = (FileType)element$iv$iv;
            boolean bl = false;
            if (!(!explicitlyAllowedFileTypes.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List forbiddenFileTypes = (List)destination$iv$iv;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileTypeRegistry registry = FileTypeRegistry.getInstance();
        for (FileType forbiddenFileType : forbiddenFileTypes) {
            if (!registry.isFileOfType(virtualFile2, forbiddenFileType)) continue;
            return false;
        }
        return true;
    }
}

