/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.requests.CreateMethodFromUsageKt;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u0010\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u0013"}, d2={"annotationExpected", "", "parent", "Lcom/intellij/psi/PsiElement;", "classExpected", "generateAddDynamicMemberAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "referenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "generateAddImportAction", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "generateAddImportActions", "", "generateCreateClassActions", "generateReferenceExpressionFixes", "interfaceExpected", "resolvesToGroovy", "qualifier", "intellij.groovy.psi"})
public final class ReferenceFixesKt {
    @NotNull
    public static final Collection<IntentionAction> generateCreateClassActions(@NotNull GrReferenceElement<?> ref) {
        Collection collection;
        PsiElement $this$parentOfType$iv = ref;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrPackageDefinition.class, (boolean)true) != null) {
            return CollectionsKt.emptyList();
        }
        GroovyQuickFixFactory factory = GroovyQuickFixFactory.getInstance();
        PsiElement parent2 = ref.getParent();
        if (parent2 instanceof GrNewExpression && ((GrNewExpression)parent2).getReferenceElement() == ref) {
            return CollectionsKt.listOf((Object)factory.createClassFromNewAction((GrNewExpression)parent2));
        }
        if (ref instanceof GrReferenceExpression && !ResolveUtil.canBeClassOrPackage((GrReferenceExpression)ref)) {
            return CollectionsKt.emptyList();
        }
        if (ReferenceFixesKt.classExpected(parent2)) {
            collection = CollectionsKt.listOf((Object[])new IntentionAction[]{factory.createClassFixAction(ref, GrCreateClassKind.CLASS), factory.createClassFixAction(ref, GrCreateClassKind.ENUM)});
        } else if (ReferenceFixesKt.interfaceExpected(parent2)) {
            collection = CollectionsKt.listOf((Object[])new IntentionAction[]{factory.createClassFixAction(ref, GrCreateClassKind.INTERFACE), factory.createClassFixAction(ref, GrCreateClassKind.TRAIT)});
        } else if (ReferenceFixesKt.annotationExpected(parent2)) {
            collection = CollectionsKt.listOf((Object)factory.createClassFixAction(ref, GrCreateClassKind.ANNOTATION));
        } else {
            IntentionAction intentionAction;
            Collection collection2;
            List result2 = CollectionsKt.mutableListOf((Object[])new IntentionAction[]{factory.createClassFixAction(ref, GrCreateClassKind.CLASS), factory.createClassFixAction(ref, GrCreateClassKind.INTERFACE)});
            if (!ref.isQualified() || ReferenceFixesKt.resolvesToGroovy(ref.getQualifier())) {
                collection2 = result2;
                intentionAction = factory.createClassFixAction(ref, GrCreateClassKind.TRAIT);
                collection2.add(intentionAction);
            }
            collection2 = result2;
            intentionAction = factory.createClassFixAction(ref, GrCreateClassKind.ENUM);
            collection2.add(intentionAction);
            collection2 = result2;
            intentionAction = factory.createClassFixAction(ref, GrCreateClassKind.ANNOTATION);
            collection2.add(intentionAction);
            if (GroovyConfigUtils.isAtLeastGroovy40(ref)) {
                collection2 = result2;
                intentionAction = factory.createClassFixAction(ref, GrCreateClassKind.RECORD);
                collection2.add(intentionAction);
            }
            collection = result2;
        }
        return collection;
    }

    private static final boolean classExpected(PsiElement parent2) {
        return parent2 instanceof GrExtendsClause && !(((GrExtendsClause)parent2).getParent() instanceof GrInterfaceDefinition);
    }

    private static final boolean interfaceExpected(PsiElement parent2) {
        return parent2 instanceof GrImplementsClause || parent2 instanceof GrExtendsClause && ((GrExtendsClause)parent2).getParent() instanceof GrInterfaceDefinition;
    }

    private static final boolean annotationExpected(PsiElement parent2) {
        return parent2 instanceof GrAnnotation;
    }

    private static final boolean resolvesToGroovy(PsiElement qualifier) {
        boolean bl;
        PsiElement psiElement = qualifier;
        if (psiElement instanceof GrReferenceElement) {
            bl = ((GrReferenceElement)qualifier).resolve() instanceof GroovyPsiElement;
        } else if (psiElement instanceof GrExpression) {
            PsiClassType type2;
            PsiType psiType = ((GrExpression)qualifier).getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = type2 = (PsiClassType)psiType;
            bl = (psiClassType != null ? psiClassType.resolve() : null) instanceof GroovyPsiElement;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<IntentionAction> generateAddImportActions(@NotNull GrReferenceElement<?> ref) {
        Collection collection;
        Object object = ReferenceFixesKt.generateAddImportAction(ref);
        if (object != null) {
            IntentionAction intentionAction;
            IntentionAction p1 = intentionAction = object;
            boolean bl = false;
            object = CollectionsKt.listOf((Object)p1);
            if (object != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    private static final IntentionAction generateAddImportAction(GrReferenceElement<?> ref) {
        if (ref.isQualified()) {
            return null;
        }
        String string = ref.getReferenceName();
        if (string == null) {
            return null;
        }
        String referenceName = string;
        CharSequence charSequence = referenceName;
        if (charSequence.length() == 0) {
            return null;
        }
        if (!(ref instanceof GrCodeReferenceElement) && Character.isLowerCase(referenceName.charAt(0))) {
            return null;
        }
        return GroovyQuickFixFactory.getInstance().createGroovyAddImportAction(ref);
    }

    @NotNull
    public static final Collection<IntentionAction> generateReferenceExpressionFixes(@NotNull GrReferenceExpression ref) {
        Object p1;
        PsiClass psiClass = QuickfixUtil.findTargetClass(ref);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass targetClass = psiClass;
        GroovyQuickFixFactory factory = GroovyQuickFixFactory.getInstance();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        IntentionAction intentionAction = ReferenceFixesKt.generateAddDynamicMemberAction(ref);
        if (intentionAction != null) {
            IntentionAction intentionAction2 = intentionAction;
            p1 = intentionAction2;
            boolean bl = false;
            actions.add((IntentionAction)p1);
        }
        if (!(targetClass instanceof SyntheticElement) || targetClass instanceof GroovyScriptClass) {
            PsiElement parent2 = ref.getParent();
            if (parent2 instanceof GrMethodCall) {
                p1 = actions;
                Iterable bl = CreateMethodFromUsageKt.generateCreateMethodActions((GrMethodCall)parent2);
                CollectionsKt.addAll((Collection)p1, (Iterable)bl);
            } else {
                p1 = actions;
                IntentionAction bl = factory.createCreateFieldFromUsageFix(ref);
                p1.add(bl);
                if (PsiUtil.isAccessedForReading(ref)) {
                    p1 = actions;
                    bl = factory.createCreateGetterFromUsageFix(ref, targetClass);
                    p1.add(bl);
                }
                if (PsiUtil.isLValue(ref)) {
                    p1 = actions;
                    bl = factory.createCreateSetterFromUsageFix(ref);
                    p1.add(bl);
                }
            }
        }
        if (!ref.isQualified()) {
            Collection collection;
            PsiElement $this$parentOfType$iv = ref;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrVariableDeclarationOwner.class, (boolean)true);
            if (!(owner instanceof GroovyFileBase) || ((GroovyFileBase)owner).isScript()) {
                collection = actions;
                IntentionAction intentionAction3 = factory.createCreateLocalVariableFromUsageFix(ref, owner);
                collection.add(intentionAction3);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)ref, GrMethod.class) != null) {
                collection = actions;
                IntentionAction intentionAction4 = factory.createCreateParameterFromUsageFix(ref);
                collection.add(intentionAction4);
            }
        }
        return actions;
    }

    private static final IntentionAction generateAddDynamicMemberAction(GrReferenceExpression referenceExpression) {
        PsiFile psiFile = referenceExpression.getContainingFile();
        if ((psiFile != null ? psiFile.getVirtualFile() : null) == null) {
            return null;
        }
        if (PsiUtil.isCall(referenceExpression)) {
            PsiType[] psiTypeArray = PsiUtil.getArgumentTypes(referenceExpression, false);
            if (psiTypeArray == null) {
                return null;
            }
            PsiType[] argumentTypes = psiTypeArray;
            return GroovyQuickFixFactory.getInstance().createDynamicMethodFix(referenceExpression, argumentTypes);
        }
        return GroovyQuickFixFactory.getInstance().createDynamicPropertyFix(referenceExpression);
    }
}

