/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyLocalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return GroovyBundle.message("inspection.message.local.variable.name.ref.too.short", new Object[0]);
        }
        if (className.length() > this.getMaxLength()) {
            return GroovyBundle.message("inspection.message.local.variable.name.ref.too.long", new Object[0]);
        }
        return GroovyBundle.message("inspection.message.local.variable.name.ref.doesnt.match.regex", this.getRegex());
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitVariable(@NotNull GrVariable grVariable) {
            super.visitVariable(grVariable);
            if (grVariable instanceof GrField || grVariable instanceof GrParameter) {
                return;
            }
            String name = grVariable.getName();
            if (GroovyLocalVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grVariable, name);
        }

        @Override
        public void visitParameter(@NotNull GrParameter grParameter) {
            super.visitParameter(grParameter);
            String name = grParameter.getName();
            PsiElement scope = grParameter.getDeclarationScope();
            if (!(scope instanceof GrCatchClause) && !(scope instanceof GrForStatement)) {
                return;
            }
            if (GroovyLocalVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grParameter, name);
        }
    }
}

