/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyUnusedImportUtil;

public class GroovyPostHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final GroovyFile myFile;
    @NotNull
    private final Editor myEditor;
    private volatile Set<GrImportStatement> myUnusedImports;
    private volatile List<HighlightInfo> myUnusedDeclarations;

    public GroovyPostHighlightingPass(@NotNull GroovyFile file, @NotNull Editor editor) {
        super(file.getProject(), editor.getDocument(), true);
        this.myFile = file;
        this.myEditor = editor;
    }

    public void doCollectInformation(final @NotNull ProgressIndicator progress) {
        VirtualFile virtualFile;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!fileIndex.isInContent(virtualFile = this.myFile.getViewProvider().getVirtualFile())) {
            return;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        final HighlightDisplayKey unusedDefKey = HighlightDisplayKey.find((String)"GroovyUnusedDeclaration");
        final boolean deadCodeEnabled = profile.isToolEnabled(unusedDefKey, (PsiElement)this.myFile);
        UnusedDeclarationInspectionBase deadCodeInspection = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)this.myFile);
        final GroovyUsageHelper usageHelper = new GroovyUsageHelper(deadCodeInspection);
        final ArrayList<HighlightInfo> unusedDeclarations = new ArrayList<HighlightInfo>();
        final HashMap usedParams = new HashMap();
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof GrReferenceExpression && !((GrReferenceElement)element).isQualified()) {
                    results = ((GrReferenceExpression)element).multiResolve(false);
                    if (results.length == 0) {
                        results = ((GrReferenceExpression)element).multiResolve(true);
                    }
                    for (GroovyResolveResult result : results) {
                        resolved = result.getElement();
                        if (!(resolved instanceof GrParameter) || resolved.getContainingFile() != GroovyPostHighlightingPass.this.myFile) continue;
                        usedParams.put((GrParameter)resolved, Boolean.TRUE);
                    }
                }
                if (deadCodeEnabled && element instanceof GrNamedElement && element instanceof PsiModifierListOwner && !UnusedSymbolUtil.isImplicitUsage((Project)element.getProject(), (PsiModifierListOwner)((PsiModifierListOwner)element)) && !GroovySuppressableInspectionTool.isElementToolSuppressedIn(element, "GroovyUnusedDeclaration") && (nameId = ((GrNamedElement)element).getNameIdentifierGroovy()).getNode().getElementType() == GroovyTokenTypes.mIDENT) {
                    name = ((GrNamedElement)element).getName();
                    if (element instanceof GrTypeDefinition && !UnusedSymbolUtil.isClassUsed((Project)GroovyPostHighlightingPass.access$000(GroovyPostHighlightingPass.this), (PsiFile)element.getContainingFile(), (PsiClass)((GrTypeDefinition)element), (ProgressIndicator)progress, (GlobalUsageHelper)usageHelper)) {
                        highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)nameId, (String)GroovyBundle.message("text.class.0.is.unused", new Object[]{name}), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix(element), (HighlightDisplayKey)unusedDefKey);
                        ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)highlightInfo);
                    } else if (element instanceof GrMethod) {
                        method = (GrMethod)element;
                        if (SpockUtils.isUnusedInSpock(method, usageHelper)) {
                            usageHelper.shouldCheckContributors = false;
                        }
                        try {
                            if (UnusedSymbolUtil.isMethodReferenced((Project)method.getProject(), (PsiFile)method.getContainingFile(), (PsiMethod)method, (ProgressIndicator)progress, (GlobalUsageHelper)usageHelper)) ** GOTO lbl40
                            message = method.isConstructor() != false ? GroovyBundle.message("text.constructor.0.is.unused", new Object[]{name}) : GroovyBundle.message("text.method.0.is.unused", new Object[]{name});
                            highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)nameId, (String)message, (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)method), (HighlightDisplayKey)unusedDefKey);
                            ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)highlightInfo);
                        }
                        finally {
                            usageHelper.shouldCheckContributors = true;
                        }
                    } else if (element instanceof GrField && GroovyPostHighlightingPass.isFieldUnused((GrField)element, progress, usageHelper)) {
                        highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)nameId, (String)GroovyBundle.message("text.property.0.is.unused", new Object[]{name}), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix(element), (HighlightDisplayKey)unusedDefKey);
                        ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)highlightInfo);
                    } else if (element instanceof GrParameter && !usedParams.containsKey(element)) {
                        usedParams.put((GrParameter)element, Boolean.FALSE);
                    }
                }
lbl40:
                // 9 sources

                super.visitElement(element);
            }
        });
        this.myUnusedImports = GroovyUnusedImportUtil.unusedImports(this.myFile);
        if (deadCodeEnabled) {
            for (GrParameter parameter : usedParams.keySet()) {
                if (((Boolean)usedParams.get(parameter)).booleanValue()) continue;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof GrMethod) {
                    GrMethod method = (GrMethod)scope;
                    if (!GroovyPostHighlightingPass.methodMayHaveUnusedParameters(method)) continue;
                    PsiElement identifier = parameter.getNameIdentifierGroovy();
                    HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, (String)GroovyBundle.message("text.parameter.0.is.unused", parameter.getName()), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)GroovyQuickFixFactory.getInstance().createRemoveUnusedGrParameterFix(parameter), (HighlightDisplayKey)unusedDefKey);
                    ContainerUtil.addIfNotNull(unusedDeclarations, (Object)highlightInfo);
                    continue;
                }
                if (!(scope instanceof GrClosableBlock)) continue;
            }
        }
        this.myUnusedDeclarations = unusedDeclarations;
    }

    private static boolean methodMayHaveUnusedParameters(GrMethod method) {
        return (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && !GroovyPostHighlightingPass.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod((PsiMethod)method, (PsiClass)method.getContainingClass()) && !PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)method);
    }

    private static boolean isFieldUnused(GrField field, ProgressIndicator progress, GlobalUsageHelper usageHelper) {
        if (!UnusedSymbolUtil.isFieldUnused((Project)field.getProject(), (PsiFile)field.getContainingFile(), (PsiField)field, (ProgressIndicator)progress, (GlobalUsageHelper)usageHelper)) {
            return false;
        }
        GrAccessorMethod[] getters = field.getGetters();
        GrAccessorMethod setter = field.getSetter();
        for (GrAccessorMethod getter : getters) {
            if (getter.findSuperMethods().length <= 0) continue;
            return false;
        }
        if (setter != null && setter.findSuperMethods().length > 0) {
            return false;
        }
        return !UnusedSymbolUtil.isImplicitRead((PsiVariable)field) && !UnusedSymbolUtil.isImplicitWrite((PsiVariable)field);
    }

    private static boolean isOverriddenOrOverrides(PsiMethod method) {
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    public void doApplyInformationToEditor() {
        IntentionAction fix;
        if (this.myUnusedDeclarations == null || this.myUnusedImports == null) {
            return;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myUnusedDeclarations);
        for (GrImportStatement unusedImport : this.myUnusedImports) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL).range(GroovyPostHighlightingPass.calculateRangeToUse(unusedImport)).descriptionAndTooltip(GroovyBundle.message("unused.import", new Object[0])).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createOptimizeImportsFix(false));
            infos.add(info);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        if (this.myUnusedImports != null && !this.myUnusedImports.isEmpty() && (fix = GroovyQuickFixFactory.getInstance().createOptimizeImportsFix(true)).isAvailable(this.myProject, this.myEditor, (PsiFile)this.myFile) && this.myFile.isWritable()) {
            fix.invoke(this.myProject, this.myEditor, (PsiFile)this.myFile);
        }
    }

    private static TextRange calculateRangeToUse(GrImportStatement unusedImport) {
        TextRange range = unusedImport.getTextRange();
        if (StringUtil.isEmptyOrSpaces((String)unusedImport.getAnnotationList().getText())) {
            return range;
        }
        int start = 0;
        for (PsiElement child = unusedImport.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != GroovyTokenTypes.kIMPORT) continue;
            start = child.getTextRange().getStartOffset();
        }
        return new TextRange(start, range.getEndOffset());
    }

    static /* synthetic */ Project access$000(GroovyPostHighlightingPass x0) {
        return x0.myProject;
    }

    private static class GroovyUsageHelper
    extends GlobalUsageHelper {
        private boolean shouldCheckContributors = true;
        private final UnusedDeclarationInspectionBase deadCodeInspection;

        private GroovyUsageHelper(UnusedDeclarationInspectionBase inspection) {
            this.deadCodeInspection = inspection;
        }

        public boolean isCurrentFileAlreadyChecked() {
            return false;
        }

        public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
            return false;
        }

        public boolean shouldCheckUsages(@NotNull PsiMember member) {
            if (this.shouldCheckContributors) {
                return this.deadCodeInspection == null || !this.deadCodeInspection.isEntryPoint((PsiElement)member);
            }
            return true;
        }
    }
}

