/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

class CatchParameterUsedVisitor
extends GroovyRecursiveElementVisitor {
    private final GrParameter parameter;
    private boolean used = false;

    CatchParameterUsedVisitor(GrParameter variable) {
        this.parameter = variable;
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (!this.used) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        PsiElement element = referenceExpression.resolve();
        if (this.parameter.equals(element)) {
            this.used = true;
        }
    }

    public void visitJSReferenceExpression(@NotNull GrReferenceExpression reference) {
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(reference);
        PsiElement element = reference.resolve();
        if (this.parameter.equals(element)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }
}

