/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.dataflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.dataflow.WritesCounterDFAInstance;
import org.jetbrains.plugins.groovy.codeInspection.dataflow.WritesCounterSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyVariableCanBeFinalInspection
extends GroovyLocalInspectionBase {
    private static final Function<ProblemDescriptor, PsiModifierList> ID_MODIFIER_LIST_PROVIDER = descriptor -> {
        PsiElement identifier = descriptor.getPsiElement();
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)identifier, PsiVariable.class);
        return variable == null ? null : variable.getModifierList();
    };

    private static void process(@NotNull GrControlFlowOwner owner, @NotNull GrVariable variable, @NotNull ProblemsHolder problemsHolder) {
        if (variable instanceof LightElement) {
            return;
        }
        if (variable.hasModifierProperty("final")) {
            return;
        }
        if (!GroovyVariableCanBeFinalInspection.checkVariableDeclaredInsideScope(owner, variable)) {
            return;
        }
        if (GroovyVariableCanBeFinalInspection.checkVariableAssignedInsideClosureOrAnonymous(owner, variable)) {
            return;
        }
        boolean isParameterTooltip = variable instanceof GrParameter && (((GrParameter)variable).getDeclarationScope() instanceof GrMethod || ((GrParameter)variable).getDeclarationScope() instanceof GrClosableBlock);
        String tooltip = GroovyBundle.message(isParameterTooltip ? "parameter.can.be.final.tooltip" : "variable.can.be.final.tooltip", variable.getName());
        problemsHolder.registerProblem(variable.getNameIdentifierGroovy(), tooltip, new LocalQuickFix[]{new GrModifierFix(variable, "final", true, ID_MODIFIER_LIST_PROVIDER)});
    }

    private static boolean checkVariableAssignedInsideClosureOrAnonymous(@NotNull GrControlFlowOwner owner, @NotNull GrVariable variable) {
        Collection references = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope()).findAll();
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (!(element instanceof GroovyPsiElement)) continue;
            GroovyPsiElement groovyElement = (GroovyPsiElement)element;
            GroovyPsiElement closure = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)groovyElement, (Class[])new Class[]{GrClosableBlock.class, GrAnonymousClassDefinition.class});
            if (closure == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)closure, (boolean)false) || !PsiUtil.isLValue(groovyElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkVariableDeclaredInsideScope(@NotNull GrControlFlowOwner owner, @NotNull PsiElement variable) {
        GrControlFlowOwner scope = owner.getParent() instanceof PsiMethod ? owner.getParent() : owner;
        return PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)variable, (boolean)false);
    }

    @Override
    public void check(@NotNull GrControlFlowOwner owner, @NotNull ProblemsHolder problemsHolder) {
        Instruction[] flow = owner.getControlFlow();
        DFAEngine<Object2IntMap<GrVariable>> engine = new DFAEngine<Object2IntMap<GrVariable>>(flow, new WritesCounterDFAInstance(), new WritesCounterSemilattice());
        List<Object2IntMap<GrVariable>> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null || dfaResult.isEmpty() || dfaResult.get(dfaResult.size() - 1) == null) {
            return;
        }
        for (Object2IntMap.Entry entry : dfaResult.get(dfaResult.size() - 1).object2IntEntrySet()) {
            if (entry.getIntValue() != 1) continue;
            GroovyVariableCanBeFinalInspection.process(owner, (GrVariable)entry.getKey(), problemsHolder);
        }
    }
}

