/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public final class VariableInitializationChecker {
    private static boolean isVariableDefinitelyInitialized(@NotNull GrVariable var, GroovyControlFlow controlFlow) {
        DFAEngine<Boolean> engine = new DFAEngine<Boolean>(controlFlow.getFlow(), new MyDfaInstance(controlFlow.getIndex(VariableDescriptorFactory.createDescriptor(var))), new MySemilattice());
        List<Boolean> result2 = engine.performDFAWithTimeout();
        if (result2 == null) {
            return false;
        }
        Boolean last = result2.get(controlFlow.getFlow().length - 1);
        return last == null ? false : last;
    }

    public static boolean isVariableDefinitelyInitializedCached(@NotNull GrVariable var, @NotNull GroovyPsiElement context, @NotNull GroovyControlFlow controlFlow) {
        Map map2 = (Map)CachedValuesManager.getCachedValue((PsiElement)var, () -> CachedValueProvider.Result.create(new HashMap(), (Object[])new Object[]{var}));
        Boolean cached = (Boolean)map2.get(context);
        if (cached != null) {
            return cached;
        }
        boolean result2 = VariableInitializationChecker.isVariableDefinitelyInitialized(var, controlFlow);
        map2.put(context, result2);
        return result2;
    }

    private static class MySemilattice
    implements Semilattice<Boolean> {
        private MySemilattice() {
        }

        @Override
        @NotNull
        public Boolean join(@NotNull List<? extends Boolean> ins) {
            if (ins.isEmpty()) {
                return false;
            }
            boolean b = true;
            Iterator<? extends Boolean> iterator2 = ins.iterator();
            while (iterator2.hasNext()) {
                boolean candidate = iterator2.next();
                b &= candidate;
            }
            return b;
        }

        @Override
        public boolean eq(@NotNull Boolean e1, @NotNull Boolean e2) {
            return e1.equals(e2);
        }
    }

    private static class MyDfaInstance
    implements DfaInstance<Boolean> {
        private final int myVar;

        MyDfaInstance(int var) {
            this.myVar = var;
        }

        @Override
        public Boolean fun(@NotNull Boolean e, @NotNull Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).getDescriptor() == this.myVar) {
                return true;
            }
            return e;
        }
    }
}

