/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.control.finalVar.InvalidWriteAccessSearcher;
import org.jetbrains.plugins.groovy.codeInspection.control.finalVar.VariableInitializationChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrFieldControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AffectedMembersCache;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public class GrFinalVariableAccessInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                super.visitMethod(method);
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    this.processLocalVars(block);
                }
                if (method.isConstructor()) {
                    this.processFieldsInConstructors(method);
                }
            }

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                super.visitFile(file);
                if (file instanceof GroovyFile && file.isScript()) {
                    this.processLocalVars(file);
                }
            }

            @Override
            public void visitField(@NotNull GrField field) {
                super.visitField(field);
                if (field instanceof LightElement) {
                    return;
                }
                GrExpression initializer = field.getInitializerGroovy();
                if (initializer != null) {
                    this.processLocalVars(initializer);
                }
                if (field.hasModifierProperty("final") && !GrFinalVariableAccessInspection.isFieldInitialized(field)) {
                    this.registerError(field.getNameIdentifierGroovy(), GroovyBundle.message("variable.0.might.not.have.been.initialized", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
                super.visitReferenceExpression(ref);
                PsiElement resolved = ref.resolve();
                if (resolved instanceof GrField && ((GrField)resolved).hasModifierProperty("final")) {
                    GrField field = (GrField)resolved;
                    PsiClass containingClass = field.getContainingClass();
                    if (PsiUtil.isLValue(ref)) {
                        if (containingClass == null || !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true)) {
                            this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        }
                    } else if (PsiUtil.isUsedInIncOrDec(ref) && (containingClass == null || !GrFinalVariableAccessInspection.isInsideConstructorOrInitializer(containingClass, ref, field.hasModifierProperty("static")))) {
                        this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                } else if (resolved instanceof GrParameter && ((GrParameter)resolved).getDeclarationScope() instanceof GrMethod && ((GrParameter)resolved).hasModifierProperty("final") && PsiUtil.isUsedInIncOrDec(ref)) {
                    this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.parameter.0", ((GrParameter)resolved).getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @Override
            public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                super.visitClassInitializer(initializer);
                this.processLocalVars(initializer.getBlock());
                this.processFieldsInClassInitializer(initializer);
            }

            private void processFieldsInConstructors(@NotNull GrMethod constructor) {
                GrOpenBlock block = constructor.getBlock();
                if (block == null) {
                    return;
                }
                GrTypeDefinition clazz = (GrTypeDefinition)constructor.getContainingClass();
                if (clazz == null) {
                    return;
                }
                GrClassInitializer[] initializers = clazz.getInitializers();
                List<GrField> fields = GrFinalVariableAccessInspection.getFinalFields(clazz);
                HashSet<GrVariable> initializedFields = new HashSet<GrVariable>();
                GrFinalVariableAccessInspection.appendFieldInitializedInDeclaration(false, fields, initializedFields);
                GrFinalVariableAccessInspection.appendFieldsInitializedInClassInitializer(initializers, null, false, fields, initializedFields);
                GrFinalVariableAccessInspection.appendInitializationFromChainedConstructors(constructor, fields, initializedFields);
                GroovyControlFlow flow = GrFinalVariableAccessInspection.buildFlowForField(block);
                Set<GrVariable> variables = GrFinalVariableAccessInspection.buildVarSet(fields, false);
                this.highlightInvalidWriteAccess(flow, variables, initializedFields);
            }

            private void processFieldsInClassInitializer(@NotNull GrClassInitializer initializer) {
                GrTypeDefinition clazz = (GrTypeDefinition)initializer.getContainingClass();
                if (clazz == null) {
                    return;
                }
                boolean isStatic = initializer.isStatic();
                GrClassInitializer[] initializers = clazz.getInitializers();
                List<GrField> fields = GrFinalVariableAccessInspection.getFinalFields(clazz);
                HashSet<GrVariable> initializedFields = new HashSet<GrVariable>();
                GrFinalVariableAccessInspection.appendFieldInitializedInDeclaration(isStatic, fields, initializedFields);
                GrFinalVariableAccessInspection.appendFieldsInitializedInClassInitializer(initializers, initializer, isStatic, fields, initializedFields);
                GroovyControlFlow flow = GrFinalVariableAccessInspection.buildFlowForField(initializer.getBlock());
                Set<GrVariable> variables = GrFinalVariableAccessInspection.buildVarSet(fields, isStatic);
                this.highlightInvalidWriteAccess(flow, variables, initializedFields);
            }

            private void processLocalVars(@NotNull GroovyPsiElement scope) {
                MultiMap<PsiElement, GrVariable> scopes = GrFinalVariableAccessInspection.collectVariables(scope);
                for (Map.Entry entry : scopes.entrySet()) {
                    PsiElement scopeToProcess = (PsiElement)entry.getKey();
                    HashSet<GrVariable> forInParameters = new HashSet<GrVariable>();
                    HashSet<GrVariable> variables = new HashSet<GrVariable>();
                    for (GrVariable var : (Collection)entry.getValue()) {
                        variables.add(var);
                        if (!(var instanceof GrParameter) || !(((GrParameter)var).getDeclarationScope() instanceof GrForStatement)) continue;
                        forInParameters.add(var);
                    }
                    GroovyControlFlow flow = GrFinalVariableAccessInspection.getFlow(scopeToProcess);
                    this.highlightInvalidWriteAccess(flow, variables, forInParameters);
                }
            }

            private void highlightInvalidWriteAccess(@NotNull GroovyControlFlow flow, @NotNull Set<GrVariable> variables, @NotNull Set<GrVariable> initializedVariables) {
                List<ReadWriteVariableInstruction> result2 = InvalidWriteAccessSearcher.findInvalidWriteAccess(flow, variables, initializedVariables);
                if (result2 == null) {
                    return;
                }
                for (ReadWriteVariableInstruction instruction : result2) {
                    int descriptor = instruction.getDescriptor();
                    if (!(flow.getVarIndices()[descriptor] instanceof ResolvedVariableDescriptor)) continue;
                    PsiElement element = instruction.getElement();
                    if (!variables.contains(((ResolvedVariableDescriptor)flow.getVarIndices()[descriptor]).getVariable()) || element == null) continue;
                    this.registerError(element, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", descriptor), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    private static boolean isInsideConstructorOrInitializer(@NotNull PsiClass containingClass, @NotNull GrReferenceExpression place, boolean isStatic) {
        GrControlFlowOwner container = ControlFlowUtils.findControlFlowOwner(place);
        PsiClass aClass = null;
        if (!isStatic && container instanceof GrMethod && ((GrMethod)((Object)container)).isConstructor()) {
            aClass = ((GrMethod)((Object)container)).getContainingClass();
        } else if (container instanceof GrClassInitializer && ((GrClassInitializer)((Object)container)).isStatic() == isStatic) {
            aClass = ((GrClassInitializer)((Object)container)).getContainingClass();
        }
        return aClass != null && containingClass.getManager().areElementsEquivalent(aClass, (PsiElement)containingClass);
    }

    @NotNull
    private static List<GrField> getFinalFields(@NotNull GrTypeDefinition clazz) {
        Object[] fields = clazz.getCodeFields();
        return ContainerUtil.filter((Object[])fields, field -> {
            GrModifierList list = field.getModifierList();
            return list != null && list.hasModifierProperty("final");
        });
    }

    private static void appendFieldInitializedInDeclaration(boolean isStatic, @NotNull List<? extends GrField> fields, @NotNull Set<? super GrVariable> initializedFields) {
        for (GrField grField : fields) {
            if (grField.hasModifierProperty("static") != isStatic || grField.getInitializerGroovy() == null) continue;
            initializedFields.add(grField);
        }
    }

    private static void appendFieldsInitializedInClassInitializer(GrClassInitializer @NotNull [] initializers, @Nullable GrClassInitializer initializerToStop, boolean isStatic, @NotNull List<? extends GrField> fields, @NotNull Set<? super GrVariable> initializedFields) {
        for (GrClassInitializer curInit : initializers) {
            if (curInit.isStatic() != isStatic) continue;
            if (curInit == initializerToStop) break;
            GrOpenBlock block = curInit.getBlock();
            GroovyControlFlow flow = GrFinalVariableAccessInspection.buildFlowForField(block);
            for (GrField grField : fields) {
                if (grField.hasModifierProperty("static") != isStatic || initializedFields.contains(grField) || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(grField, block, flow)) continue;
                initializedFields.add(grField);
            }
        }
    }

    private static void appendInitializationFromChainedConstructors(@NotNull GrMethod constructor, @NotNull List<? extends GrField> fields, @NotNull Set<? super GrVariable> initializedFields) {
        List<GrMethod> chained = GrFinalVariableAccessInspection.getChainedConstructors(constructor);
        chained.remove(0);
        for (GrMethod method : chained) {
            GrOpenBlock block = method.getBlock();
            if (block == null) continue;
            GroovyControlFlow flow = GrFinalVariableAccessInspection.buildFlowForField(block);
            for (GrField grField : fields) {
                if (grField.hasModifierProperty("static") || initializedFields.contains(grField) || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(grField, block, flow)) continue;
                initializedFields.add(grField);
            }
        }
    }

    @NotNull
    private static Set<GrVariable> buildVarSet(@NotNull List<? extends GrField> fields, boolean isStatic) {
        HashSet<GrVariable> result2 = new HashSet<GrVariable>();
        for (GrField grField : fields) {
            if (grField.hasModifierProperty("static") != isStatic) continue;
            result2.add(grField);
        }
        return result2;
    }

    private static boolean isFieldInitialized(@NotNull GrField field) {
        GrClassInitializer[] initializers;
        if (field instanceof GrEnumConstant) {
            return true;
        }
        if (field.getInitializerGroovy() != null) {
            return true;
        }
        if (GrFinalVariableAccessInspection.isImmutableField(field)) {
            return true;
        }
        if (GrFinalVariableAccessInspection.isInitializedInTupleConstructor(field)) {
            return true;
        }
        boolean isStatic = field.hasModifierProperty("static");
        GrTypeDefinition aClass = (GrTypeDefinition)field.getContainingClass();
        if (aClass == null) {
            return true;
        }
        for (GrClassInitializer initializer : initializers = aClass.getInitializers()) {
            GroovyControlFlow initializerFlow;
            GrOpenBlock block;
            if (initializer.isStatic() != isStatic || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block = initializer.getBlock(), initializerFlow = GrFinalVariableAccessInspection.buildFlowForField(block))) continue;
            return true;
        }
        if (isStatic) {
            return false;
        }
        GrMethod[] constructors = aClass.getCodeConstructors();
        if (constructors.length == 0) {
            return false;
        }
        HashSet<GrMethod> initializedConstructors = new HashSet<GrMethod>();
        HashSet<GrMethod> notInitializedConstructors = new HashSet<GrMethod>();
        block1: for (GrMethod constructor : constructors) {
            if (constructor.getBlock() == null) {
                return false;
            }
            List<GrMethod> chained = GrFinalVariableAccessInspection.getChainedConstructors(constructor);
            for (GrMethod method : chained) {
                if (initializedConstructors.contains(method)) continue block1;
                if (notInitializedConstructors.contains(method)) continue;
                GrOpenBlock block = method.getBlock();
                assert (block != null);
                boolean initialized = VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block, GrFinalVariableAccessInspection.buildFlowForField(block));
                if (initialized) {
                    initializedConstructors.add(method);
                    continue block1;
                }
                notInitializedConstructors.add(method);
            }
            return false;
        }
        return true;
    }

    private static boolean isInitializedInTupleConstructor(@NotNull GrField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiAnnotation anno = containingClass.getAnnotation("groovy.transform.TupleConstructor");
        if (anno == null) {
            return false;
        }
        AffectedMembersCache cache2 = GrGeneratedConstructorUtils.getAffectedMembersCache(anno);
        return !cache2.arePropertiesHandledByUser() && cache2.getAffectedMembers().contains(field);
    }

    private static boolean isImmutableField(@NotNull GrField field) {
        GrModifierList fieldModifierList = field.getModifierList();
        if (fieldModifierList != null && fieldModifierList.hasExplicitVisibilityModifiers()) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        return GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)aClass);
    }

    @NotNull
    private static List<GrMethod> getChainedConstructors(@NotNull GrMethod constructor) {
        PsiMethod method;
        GrConstructorInvocation invocation;
        HashSet<PsiMethod> visited = new HashSet<PsiMethod>();
        ArrayList result2 = ContainerUtil.newArrayList((Object[])new GrMethod[]{constructor});
        while ((invocation = PsiUtil.getConstructorInvocation(constructor)) != null && invocation.isThisCall() && (method = invocation.resolveMethod()) != null && method.isConstructor() && visited.add(method)) {
            result2.add((GrMethod)method);
            constructor = (GrMethod)method;
        }
        return result2;
    }

    @NotNull
    private static GroovyControlFlow buildFlowForField(@NotNull GrOpenBlock block) {
        return ControlFlowBuilder.buildControlFlow(block, GrFieldControlFlowPolicy.getInstance());
    }

    @NotNull
    private static MultiMap<PsiElement, GrVariable> collectVariables(@NotNull GroovyPsiElement scope) {
        final MultiMap scopes = MultiMap.create();
        scope.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariable(@NotNull GrVariable variable) {
                PsiElement varScope;
                super.visitVariable(variable);
                if (!(variable instanceof PsiField) && variable.hasModifierProperty("final") && (varScope = GrFinalVariableAccessInspection.findScope(variable)) != null) {
                    scopes.putValue((Object)varScope, (Object)variable);
                }
            }
        });
        return scopes;
    }

    @NotNull
    private static GroovyControlFlow getFlow(@NotNull PsiElement element) {
        return element instanceof GrControlFlowOwner ? ControlFlowUtils.getGroovyControlFlow((GrControlFlowOwner)element) : ControlFlowBuilder.buildControlFlow((GroovyPsiElement)element);
    }

    @Nullable
    private static PsiElement findScope(@NotNull GrVariable variable) {
        GrStatement body;
        GroovyPsiElement result2 = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{GrControlStatement.class, GrControlFlowOwner.class});
        if (result2 instanceof GrForStatement && (body = ((GrForStatement)result2).getBody()) != null) {
            result2 = body;
        }
        return result2;
    }
}

