/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConstantConditionalInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.ref.can.be.simplified", new Object[0]);
    }

    static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (GroovyConstantConditionalInspection.isTrue(condition)) {
            return thenExpression.getText();
        }
        return elseExpression.getText();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new ConstantConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        @NonNls String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        @NonNls String text = expression.getText();
        return "true".equals(text);
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            GrExpression condition = expression.getCondition();
            GrExpression thenExpression = expression.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = expression.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyConstantConditionalInspection.isFalse(condition) || GroovyConstantConditionalInspection.isTrue(condition)) {
                this.registerError((PsiElement)expression, expression);
            }
        }
    }

    private static class ConstantConditionalFix
    extends GroovyFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return GroovyBundle.message("intention.family.name.simplify", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrConditionalExpression expression = (GrConditionalExpression)descriptor.getPsiElement();
            String newExpression = GroovyConstantConditionalInspection.calculateReplacementExpression(expression);
            ConstantConditionalFix.replaceExpression(expression, newExpression);
        }
    }
}

