/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnusedIncDecInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(GrUnusedIncDecInspection.class);

    @NotNull
    public String getShortName() {
        return "GroovyUnusedIncOrDec";
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new GrUnusedIncDecInspectionVisitor();
    }

    @Nullable
    private static GrUnaryExpression findUnaryExpression(ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        IElementType opType = element.getNode().getElementType();
        if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
            return null;
        }
        if (!(parent2 instanceof GrUnaryExpression)) {
            return null;
        }
        GrUnaryExpression expr = (GrUnaryExpression)parent2;
        return expr;
    }

    private static class GrUnusedIncDecInspectionVisitor
    extends BaseInspectionVisitor {
        private GrUnusedIncDecInspectionVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            super.visitUnaryExpression(expression);
            IElementType opType = expression.getOperationTokenType();
            if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (!(operand instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement resolved = ((GrReferenceExpression)operand).resolve();
            if (!(resolved instanceof GrVariable) || resolved instanceof GrField) {
                return;
            }
            GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(expression);
            assert (owner != null);
            GrControlFlowOwner ownerOfDeclaration = ControlFlowUtils.findControlFlowOwner(resolved);
            if (ownerOfDeclaration != owner) {
                return;
            }
            GroovyControlFlow groovyFlow = ControlFlowUtils.getGroovyControlFlow(owner);
            Instruction cur = ControlFlowUtils.findInstruction(operand, groovyFlow.getFlow());
            if (cur == null) {
                LOG.error("no instruction found in flow.operand: " + operand.getText(), new Attachment[]{new Attachment("", owner.getText())});
            }
            Iterable<Instruction> successors = cur.allSuccessors();
            Iterator<Instruction> iterator2 = successors.iterator();
            LOG.assertTrue(iterator2.hasNext());
            Instruction writeAccess = iterator2.next();
            LOG.assertTrue(!iterator2.hasNext());
            int variableIndex = groovyFlow.getIndex(VariableDescriptorFactory.createDescriptor((GrVariable)resolved));
            List<ReadWriteVariableInstruction> accesses = ControlFlowUtils.findAccess(variableIndex, true, false, writeAccess);
            boolean allAreWrite = true;
            for (ReadWriteVariableInstruction access : accesses) {
                if (access.isWrite()) continue;
                allAreWrite = false;
                break;
            }
            if (allAreWrite) {
                if (expression.isPostfix() && PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyBundle.message("unused.0", expression.getOperationToken().getText()), new LocalQuickFix[]{new ReplacePostfixIncWithPrefixFix(expression), new RemoveIncOrDecFix(expression)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                } else if (!PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyBundle.message("unused.0", expression.getOperationToken().getText()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        }

        private static class ReplaceIncDecWithBinary
        implements LocalQuickFix {
            @IntentionFamilyName
            private final String myMessage;

            ReplaceIncDecWithBinary(GrUnaryExpression expression) {
                String opToken = expression.getOperationToken().getText();
                this.myMessage = GroovyBundle.message("replace.0.with.1", opToken, opToken.substring(0, 1));
            }

            @NotNull
            public String getFamilyName() {
                return this.myMessage;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor);
                GrExpression newExpr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperand().getText() + expr.getOperationToken().getText().charAt(0) + "1");
                expr.replaceWithExpression(newExpr, true);
            }
        }

        private static class ReplacePostfixIncWithPrefixFix
        implements LocalQuickFix {
            @IntentionFamilyName
            private final String myMessage;

            ReplacePostfixIncWithPrefixFix(GrUnaryExpression expression) {
                this.myMessage = GroovyBundle.message("replace.postfix.0.with.prefix.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                return this.myMessage;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor);
                if (expr == null) {
                    return;
                }
                GrExpression prefix = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperationToken().getText() + expr.getOperand().getText());
                expr.replaceWithExpression(prefix, true);
            }
        }

        private static class RemoveIncOrDecFix
        implements LocalQuickFix {
            @IntentionFamilyName
            private final String myMessage;

            RemoveIncOrDecFix(GrUnaryExpression expression) {
                this.myMessage = GroovyBundle.message("remove.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                return this.myMessage;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor);
                if (expr == null) {
                    return;
                }
                expr.replaceWithExpression(expr.getOperand(), true);
            }
        }
    }
}

