/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.LiteralUtilKt;

class CompareToTransformation
extends BinaryTransformation {
    CompareToTransformation() {
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options2) {
        GrExpression rhs = this.getRhs(methodCall);
        GrExpression rhsParenthesized = ParenthesesUtils.checkPrecedenceForNonBinaryOps(rhs, ParenthesesUtils.RELATIONAL_PRECEDENCE) ? ParenthesesUtils.parenthesize(rhs) : rhs;
        GrExpression replacedElement = methodCall;
        IElementType changeToOperator = CompareToTransformation.shouldChangeToOperator(methodCall, options2);
        if (changeToOperator != GroovyTokenTypes.mCOMPARE_TO) {
            replacedElement = (GrExpression)methodCall.getParent();
        }
        GrInspectionUtil.replaceExpression(replacedElement, String.format("%s %s %s", this.getLhs(methodCall).getText(), changeToOperator, rhsParenthesized.getText()));
    }

    @Nullable
    private static IElementType shouldChangeToOperator(@NotNull GrMethodCall call, ChangeToOperatorInspection.Options options2) {
        PsiElement parent2 = call.getParent();
        if (ComparisonUtils.isComparison(parent2) && LiteralUtilKt.isZero(((GrBinaryExpression)parent2).getRightOperand())) {
            IElementType token = ((GrBinaryExpression)parent2).getOperationTokenType();
            if (CompareToTransformation.isEquality(token) && !options2.shouldChangeCompareToEqualityToEquals()) {
                return null;
            }
            return token;
        }
        return GroovyTokenTypes.mCOMPARE_TO;
    }

    private static boolean isEquality(IElementType comparison) {
        return comparison == GroovyTokenTypes.mNOT_EQUAL || comparison == GroovyTokenTypes.mEQUAL;
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options2) {
        return super.couldApplyInternal(methodCall, options2) && CompareToTransformation.shouldChangeToOperator(methodCall, options2) != null;
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options2) {
        GrExpression rhs = this.getRhs(methodCall);
        return ParenthesesUtils.checkPrecedenceForNonBinaryOps(rhs, ParenthesesUtils.RELATIONAL_PRECEDENCE) || ParenthesesUtils.checkPrecedence(ParenthesesUtils.RELATIONAL_PRECEDENCE, (GrExpression)methodCall);
    }
}

