/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ChangeToOperatorInspection
extends BaseInspection {
    public boolean useDoubleNegation = true;
    public boolean shouldChangeCompareToEqualityToEquals = true;
    public boolean withoutAdditionalParentheses = false;

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCall) {
                GrExpression invokedExpression = methodCall.getInvokedExpression();
                if (!(invokedExpression instanceof GrReferenceExpression)) {
                    return;
                }
                GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
                if (referenceExpression.getDotTokenType() != GroovyTokenTypes.mDOT) {
                    return;
                }
                PsiElement highlightElement = referenceExpression.getReferenceNameElement();
                if (highlightElement == null) {
                    return;
                }
                String methodName = ChangeToOperatorInspection.this.getMethodName(methodCall);
                if (methodName == null) {
                    return;
                }
                Transformation transformation = Transformations.TRANSFORMATIONS.get(methodName);
                if (transformation == null) {
                    return;
                }
                if (transformation.couldApply(methodCall, ChangeToOperatorInspection.this.getOptions())) {
                    this.registerError(highlightElement, GroovyBundle.message("replace.with.operator.message", methodName), new LocalQuickFix[]{ChangeToOperatorInspection.this.getFix(transformation, methodName)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    @Nullable
    protected GroovyFix getFix(final @NotNull Transformation transformation, final @NotNull String methodName) {
        return new GroovyFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                return GroovyBundle.message("replace.with.operator.fix", methodName);
            }

            @Override
            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
                PsiElement call = descriptor.getPsiElement().getParent();
                if (call == null) {
                    return;
                }
                if (!((call = call.getParent()) instanceof GrMethodCall)) {
                    return;
                }
                GrMethodCall methodCall = (GrMethodCall)call;
                GrExpression invokedExpression = methodCall.getInvokedExpression();
                if (!(invokedExpression instanceof GrReferenceExpression)) {
                    return;
                }
                Options options2 = ChangeToOperatorInspection.this.getOptions();
                if (!transformation.couldApply(methodCall, options2)) {
                    return;
                }
                transformation.apply(methodCall, options2);
            }
        };
    }

    @Nullable
    public String getMethodName(@NotNull GrMethodCall methodCall) {
        PsiMethod method = methodCall.resolveMethod();
        if (method == null || method.hasModifierProperty("static")) {
            return null;
        }
        return method.getName();
    }

    @Override
    public JComponent createGroovyOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyBundle.message("replace.with.operator.double.negation.option", new Object[0]), "useDoubleNegation");
        optionsPanel.addCheckbox(GroovyBundle.message("replace.with.operator.compareTo.equality.option", new Object[0]), "shouldChangeCompareToEqualityToEquals");
        optionsPanel.addCheckbox(GroovyBundle.message("replace.with.operator.parentheses", new Object[0]), "withoutAdditionalParentheses");
        return optionsPanel;
    }

    private Options getOptions() {
        return new Options(this.useDoubleNegation, this.shouldChangeCompareToEqualityToEquals, this.withoutAdditionalParentheses);
    }

    public static final class Options {
        private final boolean useDoubleNegation;
        private final boolean shouldChangeCompareToEqualityToEquals;
        private final boolean withoutAdditionalParentheses;

        public Options(boolean useDoubleNegation, boolean shouldChangeCompareToEqualityToEquals, boolean withoutAdditionalParentheses) {
            this.useDoubleNegation = useDoubleNegation;
            this.shouldChangeCompareToEqualityToEquals = shouldChangeCompareToEqualityToEquals;
            this.withoutAdditionalParentheses = withoutAdditionalParentheses;
        }

        public boolean useDoubleNegation() {
            return this.useDoubleNegation;
        }

        public boolean shouldChangeCompareToEqualityToEquals() {
            return this.shouldChangeCompareToEqualityToEquals;
        }

        public boolean withoutAdditionalParentheses() {
            return this.withoutAdditionalParentheses;
        }
    }
}

