/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public abstract class Transformation<T extends GrExpression> {
    public boolean couldApplyRow(@NotNull GrExpression expression) {
        T casted = this.checkCast(expression);
        return casted != null && this.couldApply(casted);
    }

    public void applyRow(@NotNull GrExpression expression) {
        T casted = this.checkCast(expression);
        if (casted != null) {
            this.apply(casted);
        }
    }

    @Nullable
    protected abstract T checkCast(@NotNull GrExpression var1);

    protected abstract boolean couldApply(@NotNull T var1);

    protected abstract void apply(@NotNull T var1);

    @NlsSafe
    public abstract String getMethod();

    @NotNull
    GrExpression addParenthesesIfNeeded(@NotNull GrExpression expression) {
        return ParenthesesUtils.checkPrecedenceForNonBinaryOps(expression, ParenthesesUtils.METHOD_CALL_PRECEDENCE) ? ParenthesesUtils.parenthesize(expression) : expression;
    }
}

