/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.SmartList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyWriteReference;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AffectedMembersCache;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;

public class GroovyConstructorNamedArgumentsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Override
    protected String buildErrorString(Object ... args) {
        assert (args.length == 1 && args[0] instanceof String);
        return (String)args[0];
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
            super.visitListOrMap(listOrMap);
            GroovyConstructorReference reference = listOrMap.getConstructorReference();
            if (reference == null) {
                return;
            }
            this.processConstructor(listOrMap, reference.advancedResolve());
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression newExpression) {
            super.visitNewExpression(newExpression);
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            GroovyResolveResult constructorResolveResult = newExpression.advancedResolve();
            GrNamedArgumentsOwner owner = MyVisitor.getNamedArgumentsOwner(newExpression);
            if (owner == null) {
                return;
            }
            this.processConstructor(owner, constructorResolveResult);
        }

        public void processConstructor(@NotNull GrNamedArgumentsOwner owner, @NotNull GroovyResolveResult constructorResolveResult) {
            PsiElement constructor = constructorResolveResult.getElement();
            if (constructor != null) {
                PsiAnnotation annotation;
                if (!PsiUtil.isConstructorHasRequiredParameters((PsiMethod)constructor)) {
                    this.checkDefaultMapConstructor(owner, constructor);
                    return;
                }
                PsiClass containingClass = ((PsiMethod)constructor).getContainingClass();
                if (containingClass != null && (annotation = containingClass.getAnnotation("groovy.transform.MapConstructor")) != null) {
                    this.checkGeneratedMapConstructor(owner, containingClass, annotation);
                }
            }
        }

        private void checkGeneratedMapConstructor(@NotNull GrNamedArgumentsOwner owner, @NotNull PsiClass containingClass, @NotNull PsiAnnotation annotation) {
            Lazy affectedMembers = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> GrGeneratedConstructorUtils.getAffectedMembersCache(annotation).getAffectedMembers().stream().map(AffectedMembersCache::getExternalName).filter(Objects::nonNull).collect(Collectors.toSet()));
            for (GrNamedArgument argument : owner.getNamedArguments()) {
                PsiElement resolved;
                GrArgumentLabel label = argument.getLabel();
                if (label == null) continue;
                GroovyPropertyWriteReference propertyReference = label.getConstructorPropertyReference();
                PsiElement psiElement = resolved = propertyReference == null ? null : propertyReference.resolve();
                if (resolved != null) {
                    String name = label.getName();
                    if (name == null || ((Set)affectedMembers.getValue()).contains(name)) continue;
                    LocalQuickFix[] fix = MyVisitor.generateMapConstructorFix(resolved, containingClass, annotation);
                    this.registerError((PsiElement)label, GroovyBundle.message("inspection.message.property.0.is.ignored.by.map.constructor", name), fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    continue;
                }
                this.registerAbsentIdentifierError(containingClass, label);
            }
        }

        private static LocalQuickFix @NotNull [] generateMapConstructorFix(@NotNull PsiElement resolvedElement, @NotNull PsiClass containingClass, @NotNull PsiAnnotation annotation) {
            if (annotation instanceof LightElement) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (!(containingClass instanceof GrTypeDefinition)) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (!(resolvedElement instanceof PsiMember)) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (((PsiMember)resolvedElement).getContainingClass() != containingClass && resolvedElement instanceof PsiMethod) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (annotation.hasAttribute("includes") || annotation.hasAttribute("excludes")) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createMapConstructorFix()};
        }

        private void registerAbsentIdentifierError(@NotNull PsiClass clazz, @NotNull GrArgumentLabel label) {
            SmartList fixes = new SmartList();
            if (clazz instanceof GrTypeDefinition) {
                fixes.add(GroovyQuickFixFactory.getInstance().createCreateFieldFromConstructorLabelFix((GrTypeDefinition)clazz, label.getNamedArgument()));
            }
            fixes.add(GroovyQuickFixFactory.getInstance().createDynamicPropertyFix(label, clazz));
            this.registerError((PsiElement)label, GroovyBundle.message("no.such.property", label.getName()), fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }

        @Nullable
        private static GrNamedArgumentsOwner getNamedArgumentsOwner(@NotNull GrNewExpression newExpression) {
            GrArgumentList argList = newExpression.getArgumentList();
            if (argList == null) {
                return null;
            }
            GrExpression[] expressionArguments = argList.getExpressionArguments();
            GrNamedArgument[] namedArguments = argList.getNamedArguments();
            if (expressionArguments.length == 1 && namedArguments.length == 0 && expressionArguments[0] instanceof GrListOrMap) {
                return (GrNamedArgumentsOwner)((Object)expressionArguments[0]);
            }
            if (expressionArguments.length == 0) {
                return argList;
            }
            return null;
        }

        private void checkDefaultMapConstructor(GrNamedArgumentsOwner owner, PsiElement element) {
            GrNamedArgument[] args;
            if (owner == null) {
                return;
            }
            for (GrNamedArgument arg : args = owner.getNamedArguments()) {
                PsiElement resolved;
                GrArgumentLabel label = arg.getLabel();
                if (label == null) continue;
                String labelName = label.getName();
                if (labelName == null) {
                    PsiElement nameElement = label.getNameElement();
                    if (nameElement instanceof GrExpression) {
                        PsiType argType = ((GrExpression)nameElement).getType();
                        if (argType == null || TypesUtil.isAssignableByMethodCallConversion((PsiType)TypesUtil.createType("java.lang.String", arg), argType, arg)) continue;
                        this.registerError(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                        continue;
                    }
                    if ("*".equals(nameElement.getText())) continue;
                    this.registerError(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                    continue;
                }
                GroovyPropertyWriteReference propertyReference = label.getConstructorPropertyReference();
                PsiElement psiElement = resolved = propertyReference == null ? null : propertyReference.resolve();
                if (resolved == null) {
                    if (element instanceof PsiMember && !(element instanceof PsiClass)) {
                        element = ((PsiMember)element).getContainingClass();
                    }
                    if (!(element instanceof PsiClass)) continue;
                    this.registerAbsentIdentifierError((PsiClass)element, label);
                    continue;
                }
                if (!(resolved instanceof PsiModifierListOwner) || !((PsiModifierListOwner)resolved).hasModifierProperty("final")) continue;
                this.registerError((PsiElement)label, GroovyBundle.message("inspection.message.property.0.is.final", labelName), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
    }
}

