/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;

public class GrModifierFix
extends GroovyFix {
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST = descriptor -> {
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof PsiModifierList) : element;
        return (PsiModifierList)element;
    };
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST_OWNER = descriptor -> {
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof PsiModifierListOwner) : element;
        return ((PsiModifierListOwner)element).getModifierList();
    };
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST_CHILD = descriptor -> {
        PsiElement element = descriptor.getPsiElement().getParent();
        assert (element instanceof PsiModifierList) : element;
        return (PsiModifierList)element;
    };
    private final String myModifier;
    @IntentionName
    private final String myText;
    private final boolean myDoSet;
    private final Function<? super ProblemDescriptor, ? extends PsiModifierList> myModifierListProvider;

    public GrModifierFix(@NotNull GrVariable member, @GrModifier.GrModifierConstant String modifier, boolean doSet, @NotNull Function<? super ProblemDescriptor, ? extends PsiModifierList> modifierListProvider) {
        this(GrModifierFix.initText(doSet, member.getName(), modifier), modifier, doSet, modifierListProvider);
    }

    public GrModifierFix(@NotNull PsiMember member, @GrModifier.GrModifierConstant String modifier, boolean showContainingClass, boolean doSet, @NotNull Function<? super ProblemDescriptor, ? extends PsiModifierList> modifierListProvider) {
        this(GrModifierFix.initText(doSet, GrModifierFix.getMemberName(member, showContainingClass), modifier), modifier, doSet, modifierListProvider);
    }

    public GrModifierFix(@IntentionName @NotNull String text, @GrModifier.GrModifierConstant String modifier, boolean doSet, @NotNull Function<? super ProblemDescriptor, ? extends PsiModifierList> modifierListProvider) {
        this.myText = text;
        this.myModifier = modifier;
        this.myModifierListProvider = modifierListProvider;
        this.myDoSet = doSet;
    }

    @IntentionName
    public static String initText(boolean doSet, @NlsSafe @NotNull String name, @NlsSafe @NotNull String modifier) {
        return GroovyBundle.message(doSet ? "change.modifier" : "change.modifier.not", name, GrModifierFix.toPresentableText(modifier));
    }

    private static String getMemberName(PsiMember member, boolean showContainingClass) {
        if (showContainingClass) {
            PsiClass containingClass = member.getContainingClass();
            String containingClassName = containingClass != null ? containingClass.getName() + "." : "";
            return containingClassName + member.getName();
        }
        return member.getName();
    }

    public static String toPresentableText(String modifier) {
        return GroovyBundle.message(modifier + ".visibility.presentation", new Object[0]);
    }

    @NotNull
    public String getName() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("change.modifier.family.name", new Object[0]);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiModifierList modifierList = this.getModifierList(descriptor);
        modifierList.setModifierProperty(this.myModifier, this.myDoSet);
    }

    private PsiModifierList getModifierList(ProblemDescriptor descriptor) {
        return (PsiModifierList)this.myModifierListProvider.fun((Object)descriptor);
    }
}

