/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.GrInspectionUIUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;

public abstract class BaseInspection
extends LocalInspectionTool {
    @NotNull
    public Set<String> explicitlyEnabledFileTypes = new HashSet<String>();

    @Nullable
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        return null;
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    public final JComponent createOptionsPanel() {
        JComponent actualPanel = this.createGroovyOptionsPanel();
        return GrInspectionUIUtil.enhanceInspectionToolPanel(this, this.explicitlyEnabledFileTypes, actualPanel);
    }

    @Nullable
    protected JComponent createGroovyOptionsPanel() {
        return null;
    }

    @Nullable
    protected LocalQuickFix buildFix(@NotNull PsiElement location) {
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        BaseInspectionVisitor visitor2 = this.buildVisitor();
        visitor2.initialize(this, holder, isOnTheFly);
        return new GroovyPsiElementVisitor(visitor2){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (GrInspectionUIUtil.checkInspectionEnabledByFileType(BaseInspection.this, element, BaseInspection.this.explicitlyEnabledFileTypes)) {
                    super.visitElement(element);
                }
            }
        };
    }

    @NotNull
    protected abstract BaseInspectionVisitor buildVisitor();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getProbableBugs() {
        return GroovyBundle.message("inspection.bugs", new Object[0]);
    }
}

