/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.tree.TreeUtil;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicToolWindowWrapper;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DMethodElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrDynamicImplicitElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrDynamicImplicitMethod
extends GrLightMethodBuilder
implements GrDynamicImplicitElement {
    private static final Logger LOG = Logger.getInstance(GrDynamicImplicitMethod.class);
    private final String myContainingClassName;
    private final List<? extends ParamInfo> myParamInfos;
    private final String myReturnType;

    public GrDynamicImplicitMethod(PsiManager manager, String name, String containingClassName, boolean isStatic, List<? extends ParamInfo> paramInfos, String returnType2) {
        super(manager, name);
        this.myContainingClassName = containingClassName;
        this.myParamInfos = paramInfos;
        this.setOriginInfo("dynamic method");
        if (isStatic) {
            this.addModifier("static");
        }
        for (ParamInfo paramInfo : paramInfos) {
            this.addParameter(paramInfo.name, paramInfo.type);
        }
        this.setReturnType(returnType2, this.getResolveScope());
        this.myReturnType = returnType2;
    }

    @Override
    public String getContainingClassName() {
        return this.myContainingClassName;
    }

    @Override
    @Nullable
    public PsiClass getContainingClassElement() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myContainingClassName, ProjectScope.getAllScope((Project)this.getProject()));
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        String[] argumentsTypes = QuickfixUtil.getArgumentsTypes(this.myParamInfos);
        DynamicManager.getInstance(this.getProject()).replaceDynamicMethodName(this.getContainingClassName(), this.getName(), name, argumentsTypes);
        return super.setName(name);
    }

    @Override
    public GrDynamicImplicitMethod copy() {
        return new GrDynamicImplicitMethod(this.myManager, this.getName(), this.getContainingClassName(), this.hasModifierProperty("static"), new ArrayList<ParamInfo>(this.myParamInfos), this.myReturnType);
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass psiClass = this.getContainingClassElement();
        if (psiClass == null) {
            return null;
        }
        return psiClass.getContainingFile();
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        return (PsiClass)ReadAction.compute(() -> {
            try {
                GrTypeElement typeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(this.myContainingClassName);
                if (typeElement == null) {
                    return null;
                }
                PsiType type2 = typeElement.getType();
                if (!(type2 instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type2).resolve();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
    }

    @Override
    public String toString() {
        return "DynamicMethod:" + this.getName();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return GlobalSearchScope.projectScope((Project)this.getProject());
    }

    public void navigate(boolean requestFocus) {
        DynamicToolWindowWrapper.getInstance(this.getProject()).getToolWindow().activate(() -> {
            DynamicToolWindowWrapper toolWindowWrapper = DynamicToolWindowWrapper.getInstance(this.getProject());
            TreeTable treeTable = toolWindowWrapper.getTreeTable();
            ListTreeTableModelOnColumns model = toolWindowWrapper.getTreeTableModel();
            Object root = model.getRoot();
            if (!(root instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)root;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            PsiClassType fqClassName = facade.getElementFactory().createTypeByFQClassName(this.myContainingClassName, ProjectScope.getAllScope((Project)this.getProject()));
            PsiClass psiClass = fqClassName.resolve();
            if (psiClass == null) {
                return;
            }
            PsiClass trueClass = null;
            DMethodElement methodElement = null;
            GrParameter[] parameters2 = this.getParameters();
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (GrParameter parameter : parameters2) {
                String type2 = parameter.getType().getCanonicalText();
                parameterTypes.add(type2);
            }
            for (PsiClass aSuper : PsiUtil.iterateSupers(psiClass, true)) {
                methodElement = DynamicManager.getInstance(this.getProject()).findConcreteDynamicMethod(aSuper.getQualifiedName(), this.getName(), ArrayUtilRt.toStringArray(parameterTypes));
                if (methodElement == null) continue;
                trueClass = aSuper;
                break;
            }
            if (trueClass == null) {
                return;
            }
            DefaultMutableTreeNode classNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)treeRoot, (Object)new DClassElement(this.getProject(), trueClass.getQualifiedName()));
            if (classNode == null) {
                return;
            }
            DefaultMutableTreeNode desiredNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)classNode, (Object)methodElement);
            if (desiredNode == null) {
                return;
            }
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)desiredNode);
            treeTable.getTree().expandPath(path);
            treeTable.getTree().setSelectionPath(path);
            treeTable.getTree().fireTreeExpanded(path);
            treeTable.revalidate();
            treeTable.repaint();
        }, true);
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public String getPresentableText() {
        return this.getName();
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return JetgroovyIcons.Groovy.Method;
    }
}

