/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureDialog;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodDescriptor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator;
import org.jetbrains.plugins.groovy.refactoring.ui.MethodOrClosureScopeChooser;

public class CreateParameterFromUsageFix
extends Intention
implements MethodOrClosureScopeChooser.JBPopupOwner {
    private final String myName;
    private JBPopup myEnclosingMethodsPopup = null;

    public CreateParameterFromUsageFix(GrReferenceExpression ref) {
        this.myName = ref.getReferenceName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("create.parameter.from.usage.family.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return GroovyBundle.message("create.parameter.from.usage", this.myName);
    }

    @Override
    public JBPopup get() {
        return this.myEnclosingMethodsPopup;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element instanceof GrReferenceExpression) {
            this.findScope((GrReferenceExpression)element, editor, project);
        }
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return element instanceof GrExpression;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                return element instanceof GrReferenceExpression;
            }
        };
    }

    private void findScope(@NotNull GrReferenceExpression ref, @NotNull Editor editor, Project project) {
        GrMethod parent2;
        GrTopStatement place = ref;
        ArrayList<GrMethod> scopes = new ArrayList<GrMethod>();
        while ((parent2 = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class)) != null) {
            scopes.add(parent2);
            place = parent2;
        }
        if (scopes.size() == 1) {
            GrMethod owner2 = (GrMethod)scopes.get(0);
            PsiMethod toSearchFor = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)owner2);
            if (toSearchFor == null) {
                return;
            }
            CreateParameterFromUsageFix.showDialog(toSearchFor, ref, project);
        } else if (scopes.size() > 1) {
            this.myEnclosingMethodsPopup = MethodOrClosureScopeChooser.create(scopes, editor, this, (PairFunction<? super GrParameterListOwner, ? super PsiElement, Object>)((PairFunction)(owner, element) -> {
                if (owner != null) {
                    CreateParameterFromUsageFix.showDialog((PsiMethod)owner, ref, project);
                }
                return null;
            }));
            this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
        }
    }

    private static void showDialog(@NotNull PsiMethod method, @NotNull GrReferenceExpression ref, @NotNull Project project) {
        PsiType type2;
        String name = ref.getReferenceName();
        List<PsiType> types = GroovyExpectedTypesProvider.getDefaultExpectedTypes(ref);
        PsiType unboxed = types.isEmpty() ? null : TypesUtil.unboxPrimitiveTypeWrapper(types.get(0));
        Object object = type2 = unboxed != null ? unboxed : PsiType.getJavaLangObject((PsiManager)ref.getManager(), (GlobalSearchScope)ref.getResolveScope());
        if (method instanceof GrMethod) {
            GrMethodDescriptor descriptor = new GrMethodDescriptor((GrMethod)method);
            GrChangeSignatureDialog dialog = new GrChangeSignatureDialog(project, descriptor, true, ref);
            List parameters2 = dialog.getParameters();
            parameters2.add(CreateParameterFromUsageFix.createParameterInfo(name, type2));
            dialog.setParameterInfos(parameters2);
            dialog.show();
        } else {
            JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(project, method, false, (PsiElement)ref);
            ArrayList<ParameterInfoImpl> parameterInfos = new ArrayList<ParameterInfoImpl>(Arrays.asList(ParameterInfoImpl.fromMethod((PsiMethod)method)));
            ParameterInfoImpl parameterInfo = ParameterInfoImpl.createNew().withName(name).withType(type2).withDefaultValue(PsiTypesUtil.getDefaultValueOfType((PsiType)type2));
            if (!method.isVarArgs()) {
                parameterInfos.add(parameterInfo);
            } else {
                parameterInfos.add(parameterInfos.size() - 1, parameterInfo);
            }
            dialog.setParameterInfos(parameterInfos);
            dialog.show();
        }
    }

    private static GrParameterInfo createParameterInfo(String name, PsiType type2) {
        String notNullName = name != null ? name : "";
        String defaultValueText = GroovyToJavaGenerator.getDefaultValueText(type2.getCanonicalText());
        return new GrParameterInfo(notNullName, defaultValueText, "", type2, -1, false);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

