/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.IntentionUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ConvertLambdaToClosureAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "lambda", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;)V", "myLambda", "Lcom/intellij/psi/SmartPsiElementPointer;", "closureText", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.groovy.psi"})
public final class ConvertLambdaToClosureAction
implements IntentionAction {
    private final SmartPsiElementPointer<GrLambdaExpression> myLambda;

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("action.convert.lambda.to.closure", new Object[0]);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        return this.myLambda.getElement() != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        GrLambdaExpression grLambdaExpression = (GrLambdaExpression)this.myLambda.getElement();
        if (grLambdaExpression == null) {
            return;
        }
        GrLambdaExpression lambda2 = grLambdaExpression;
        String string = this.closureText(lambda2);
        if (string == null) {
            return;
        }
        String closureText = string;
        GrClosableBlock closure = GroovyPsiElementFactory.getInstance(project).createClosureFromText(closureText);
        lambda2.replaceWithExpression(closure, false);
    }

    private final String closureText(GrLambdaExpression lambda2) {
        GrParameterList parameterList = lambda2.getParameterList();
        GrLambdaBody grLambdaBody = lambda2.getBody();
        if (grLambdaBody == null) {
            return null;
        }
        GrLambdaBody body = grLambdaBody;
        StringBuilder closureText = new StringBuilder();
        closureText.append("{");
        if (parameterList.getParametersCount() != 0) {
            IntentionUtilKt.appendTextBetween(closureText, parameterList.getText(), parameterList.getLParen(), parameterList.getRParen());
        }
        IntentionUtilKt.appendElements(closureText, parameterList, body);
        if (body instanceof GrBlockLambdaBody) {
            IntentionUtilKt.appendTextBetween(closureText, ((GrBlockLambdaBody)body).getText(), ((GrBlockLambdaBody)body).getLBrace(), ((GrBlockLambdaBody)body).getRBrace());
        } else {
            closureText.append(body.getText());
        }
        closureText.append("}");
        return closureText.toString();
    }

    public ConvertLambdaToClosureAction(@NotNull GrLambdaExpression lambda2) {
        this.myLambda = PointersKt.createSmartPointer$default((PsiElement)lambda2, null, (int)1, null);
    }
}

