/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.AliasedAnnotationHolder;
import org.jetbrains.plugins.groovy.annotator.checkers.AnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;

public class GrAliasAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        ArrayList<GrAnnotation> aliasedAnnotations = GrAliasAnnotationChecker.getAliasedAnnotations(annotation);
        if (aliasedAnnotations == null) {
            return false;
        }
        GrCodeReferenceElement ref = annotation.getClassReference();
        for (GrAnnotation aliased : aliasedAnnotations) {
            PsiElement toHighlight = AliasedAnnotationHolder.findCodeElement(ref, annotation, ref);
            AnnotationChecker.checkApplicability(aliased, annotation.getOwner(), holder, toHighlight);
        }
        return true;
    }

    @Nullable
    private static ArrayList<GrAnnotation> getAliasedAnnotations(GrAnnotation annotation) {
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return null;
        }
        ArrayList<GrAnnotation> aliasedAnnotations = new ArrayList<GrAnnotation>();
        GrAnnotationCollector.collectAnnotations(aliasedAnnotations, annotation, annotationCollector);
        return aliasedAnnotations;
    }

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return false;
        }
        ArrayList annotations2 = new ArrayList();
        Set<String> usedAttributes = GrAnnotationCollector.collectAnnotations(annotations2, annotation, annotationCollector);
        for (GrAnnotation aliased : annotations2) {
            PsiElement highlightElement;
            Pair<PsiElement, @InspectionMessage String> r = AnnotationChecker.checkAnnotationArgumentList(aliased, holder);
            if (r == null || r.getSecond() == null) continue;
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, (String)r.getSecond());
            PsiElement element = (PsiElement)r.getFirst();
            PsiElement psiElement = highlightElement = element != null && PsiTreeUtil.isAncestor((PsiElement)annotation, (PsiElement)element, (boolean)true) ? element : null;
            if (highlightElement != null) {
                builder = builder.range(highlightElement);
            }
            builder.create();
            return true;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        String aliasQName = annotation.getQualifiedName();
        if (attributes.length == 1 && attributes[0].getNameIdentifierGroovy() == null && !usedAttributes.contains("value")) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("at.interface.0.does.not.contain.attribute", aliasQName, "value")).range((PsiElement)attributes[0]).create();
        }
        for (GrAnnotationNameValuePair pair : attributes) {
            PsiElement nameIdentifier = pair.getNameIdentifierGroovy();
            if (nameIdentifier == null || usedAttributes.contains(pair.getName())) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("at.interface.0.does.not.contain.attribute", aliasQName, pair.getName())).range(nameIdentifier).create();
        }
        return true;
    }
}

