/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator25;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamData;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamsUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkRequiredNamedArguments", "", "callExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "immutableCheck", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "visitCallExpression", "visitField", "visitMethod", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "intellij.groovy.psi"})
public final class GroovyAnnotator25
extends GroovyElementVisitor {
    private final AnnotationHolder holder;

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethod(@NotNull GrMethod method) {
        void $this$filterTo$iv$iv;
        Object it;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = NamedParamsUtil.collectAllParamsFromNamedVariantMethod(method);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            element$iv$iv = iterator2.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry $dstr$name$parameters = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            element$iv$iv = $dstr$name$parameters;
            it = (String)element$iv$iv.getKey();
            element$iv$iv = $dstr$name$parameters;
            List parameters2 = (List)element$iv$iv.getValue();
            String parametersList2 = CollectionsKt.joinToString$default((Iterable)parameters2, null, null, null, (int)0, null, (Function1)visitMethod.3.parametersList.1.INSTANCE, (int)31, null);
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)parameters2, (int)1);
            boolean $i$f$map = false;
            Iterable $i$f$getOrPut = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$_u24__u24$parameter;
                PsiParameter parameter;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                PsiParameter psiParameter = parameter = (PsiParameter)$dstr$_u24__u24$parameter.component2();
                collection.add(psiParameter);
            }
            List duplicatingParameters = (List)destination$iv$iv2;
            for (PsiParameter parameter : duplicatingParameters) {
                PsiIdentifier nameIdentifier;
                void name;
                if (parameter.getNameIdentifier() == null) {
                    continue;
                }
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("duplicating.named.parameter", name, parametersList2)).range((PsiElement)nameIdentifier).create();
            }
        }
        super.visitMethod(method);
    }

    @Override
    public void visitField(@NotNull GrField field) {
        super.visitField(field);
        this.immutableCheck(field);
    }

    private final void immutableCheck(GrField field) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        if (!field.hasModifierProperty("static") && GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)containingClass) && !GrImmutableUtils.isImmutable(field)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("field.should.be.immutable", field.getName())).range(field.getNameIdentifierGroovy()).create();
        }
    }

    @Override
    public void visitCallExpression(@NotNull GrCallExpression callExpression) {
        this.checkRequiredNamedArguments(callExpression);
        super.visitCallExpression(callExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRequiredNamedArguments(GrCallExpression callExpression) {
        void $this$filterTo$iv$iv;
        NamedParamData it;
        void $this$mapNotNullTo$iv$iv;
        if (!CompileStaticUtil.isCompileStatic(callExpression)) {
            return;
        }
        GrNamedArgument[] $this$mapNotNull$iv = callExpression.getNamedArguments();
        boolean $i$f$mapNotNull = false;
        GrNamedArgument[] grNamedArgumentArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            it = element$iv$iv;
            boolean bl2 = false;
            if (it.getLabelName() == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set namedArguments = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (namedArguments.isEmpty()) {
            return;
        }
        GroovyResolveResult resolveResult2 = callExpression.advancedResolve();
        PsiElement psiElement = resolveResult2.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        Object[] parameters2 = method.getParameterList().getParameters();
        PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters2);
        if (psiParameter == null) {
            return;
        }
        PsiParameter mapParameter = psiParameter;
        Iterable $this$filter$iv = NamedParamsUtil.collectNamedParams(mapParameter);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NamedParamData)element$iv$iv;
            boolean bl = false;
            if (!it.getRequired()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredNamedParams = (List)destination$iv$iv2;
        for (NamedParamData namedParam : requiredNamedParams) {
            if (namedArguments.contains(namedParam.getName())) continue;
            String message = GroovyBundle.message("missing.required.named.parameter", namedParam.getName());
            this.holder.newAnnotation(HighlightSeverity.ERROR, message).create();
        }
    }

    public GroovyAnnotator25(@NotNull AnnotationHolder holder) {
        this.holder = holder;
    }
}

