/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ExpressionConverter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.annotator.ImplKt;
import org.jetbrains.plugins.groovy.annotator.StringInjectionKt;
import org.jetbrains.plugins.groovy.annotator.UnresolvedReferenceAnnotatorSink;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.annotator.checkers.AnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.checkers.GeneratedConstructorAnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.intentions.ChangeExtendsImplementsQuickFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrMoveClassToCorrectPlaceFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrRemoveExceptionFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrReplacePrimitiveTypeWithWrapperFix;
import org.jetbrains.plugins.groovy.annotator.intentions.ReplaceDelimiterFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GroovyUnresolvedAccessChecker;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrFlowInterruptingStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrRecordDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrArrayTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrBuiltInTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalExpressionFlowUtil;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AffectedMembersCache;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.InheritConstructorContributor;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public final class GroovyAnnotator
extends GroovyElementVisitor {
    private static final Logger LOG = Logger.getInstance(GroovyAnnotator.class);
    public static final Condition<PsiClass> IS_INTERFACE = aClass -> aClass.isInterface();
    private static final Condition<PsiClass> IS_NOT_INTERFACE = aClass -> !aClass.isInterface();
    public static final Condition<PsiClass> IS_TRAIT = aClass -> GrTraitUtil.isTrait(aClass);
    private final AnnotationHolder myHolder;

    public GroovyAnnotator(@NotNull AnnotationHolder holder) {
        this.myHolder = holder;
    }

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        PsiElement parent2 = typeArgumentList.getParent();
        if (!(parent2 instanceof GrReferenceElement)) {
            return;
        }
        if (parent2 instanceof GrCodeReferenceElement && !PsiUtilKt.mayContainTypeArguments((GrCodeReferenceElement)parent2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("type.argument.list.is.not.allowed.here", new Object[0])).create();
            return;
        }
        GroovyResolveResult resolveResult2 = ((GrReferenceElement)parent2).advancedResolve();
        PsiElement resolved = resolveResult2.getElement();
        PsiSubstitutor substitutor2 = resolveResult2.getSubstitutor();
        if (resolved == null) {
            return;
        }
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("type.argument.list.is.not.allowed.here", new Object[0])).create();
            return;
        }
        if (typeArgumentList.isDiamond()) {
            return;
        }
        PsiTypeParameter[] parameters2 = ((PsiTypeParameterListOwner)resolved).getTypeParameters();
        GrTypeElement[] arguments2 = typeArgumentList.getTypeArgumentElements();
        if (arguments2.length != parameters2.length) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("wrong.number.of.type.arguments", arguments2.length, parameters2.length)).create();
            return;
        }
        block0: for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeParameter parameter = parameters2[i];
            PsiClassType[] superTypes = parameter.getExtendsListTypes();
            PsiType argType = arguments2[i].getType();
            for (PsiClassType superType : superTypes) {
                PsiType substitutedSuper = substitutor2.substitute((PsiType)superType);
                if (substitutedSuper == null || substitutedSuper.isAssignableFrom(argType)) continue;
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("type.argument.0.is.not.in.its.bound.should.extend.1", argType.getCanonicalText(), superType.getCanonicalText())).range((PsiElement)arguments2[i]).create();
                continue block0;
            }
        }
    }

    @Override
    public void visitNamedArgument(@NotNull GrNamedArgument argument) {
        PsiElement pParent;
        PsiElement parent2 = argument.getParent();
        if (parent2 instanceof GrArgumentList && (pParent = parent2.getParent()) instanceof GrIndexProperty) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("named.arguments.are.not.allowed.inside.index.operations", new Object[0])).create();
        }
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element.getParent() instanceof GrDocReferenceElement) {
            GroovyAnnotator.checkGrDocReferenceElement(this.myHolder, element);
        }
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement statement) {
        GrCatchClause[] clauses = statement.getCatchClauses();
        if (statement.getResourceList() == null && clauses.length == 0 && statement.getFinallyClause() == null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("try.without.catch.finally", new Object[0])).range(statement.getFirstChild()).create();
            return;
        }
        ArrayList<PsiType> usedExceptions = new ArrayList<PsiType>();
        for (GrCatchClause clause : clauses) {
            PsiType type2;
            GrParameter parameter = clause.getParameter();
            if (parameter == null) continue;
            GrTypeElement typeElement = parameter.getTypeElementGroovy();
            Object object = type2 = typeElement != null ? typeElement.getType() : TypesUtil.createType("java.lang.Exception", statement);
            if (typeElement instanceof GrDisjunctionTypeElement) {
                Object[] elements = ((GrDisjunctionTypeElement)typeElement).getTypeElements();
                PsiType[] types = (PsiType[])ContainerUtil.map2Array((Object[])elements, PsiType.class, GrTypeElement::getType);
                ArrayList<PsiType> usedInsideDisjunction = new ArrayList<PsiType>();
                for (int i = 0; i < types.length; ++i) {
                    if (!this.checkExceptionUsed(usedExceptions, parameter, (GrTypeElement)elements[i], types[i])) continue;
                    usedInsideDisjunction.add(types[i]);
                    for (int j = 0; j < types.length; ++j) {
                        if (i == j || !types[j].isAssignableFrom(types[i])) continue;
                        this.myHolder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("unnecessary.type", types[i].getCanonicalText(), types[j].getCanonicalText())).range((PsiElement)elements[i]).withFix((IntentionAction)new GrRemoveExceptionFix(true)).create();
                    }
                }
                usedExceptions.addAll(usedInsideDisjunction);
                continue;
            }
            if (!this.checkExceptionUsed(usedExceptions, parameter, typeElement, type2)) continue;
            usedExceptions.add(type2);
        }
    }

    @Override
    public void visitCatchClause(@NotNull GrCatchClause clause) {
        GrParameter parameter = clause.getParameter();
        if (parameter == null) {
            return;
        }
        GrTypeElement typeElement = parameter.getTypeElementGroovy();
        if (typeElement != null) {
            PsiType type2 = typeElement.getType();
            if (type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() == null) {
                return;
            }
            PsiClassType throwable = TypesUtil.createType("java.lang.Throwable", clause);
            if (!throwable.isAssignableFrom(type2)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("catch.statement.parameter.type.should.be.a.subclass.of.throwable", new Object[0])).range((PsiElement)typeElement).create();
            }
        }
    }

    @Override
    public void visitDocComment(@NotNull GrDocComment comment) {
        String text = comment.getText();
        if (!text.endsWith("*/")) {
            TextRange range = comment.getTextRange();
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("doc.end.expected", new Object[0])).range(new TextRange(range.getEndOffset() - 1, range.getEndOffset())).create();
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        GroovyAnnotator.checkDuplicateModifiers(this.myHolder, variableDeclaration.getModifierList(), null);
        if (variableDeclaration.isTuple()) {
            GrModifierList list = variableDeclaration.getModifierList();
            PsiElement last = PsiUtil.skipWhitespacesAndComments(list.getLastChild(), false);
            if (last != null) {
                IElementType type2 = last.getNode().getElementType();
                if (type2 != GroovyTokenTypes.kDEF) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("tuple.declaration.should.end.with.def.modifier", new Object[0])).range((PsiElement)list).create();
                }
            } else {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("tuple.declaration.should.end.with.def.modifier", new Object[0])).range((PsiElement)list).create();
            }
        } else {
            GrTypeParameterList typeParameterList = (GrTypeParameterList)PsiTreeUtil.findChildOfType((PsiElement)variableDeclaration, GrTypeParameterList.class);
            if (typeParameterList != null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("type.parameters.are.unexpected", new Object[0])).range((PsiElement)typeParameterList).create();
            }
        }
    }

    private boolean checkExceptionUsed(List<PsiType> usedExceptions, GrParameter parameter, GrTypeElement typeElement, PsiType type2) {
        for (PsiType exception : usedExceptions) {
            if (!exception.isAssignableFrom(type2)) continue;
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("exception.0.has.already.been.caught", type2.getCanonicalText())).range((PsiElement)(typeElement != null ? typeElement : parameter.getNameIdentifierGroovy())).withFix((IntentionAction)new GrRemoveExceptionFix(parameter.getTypeElementGroovy() instanceof GrDisjunctionTypeElement)).create();
            return false;
        }
        return true;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        this.checkStringNameIdentifier(referenceExpression);
        GroovyAnnotator.checkThisOrSuperReferenceExpression(referenceExpression, this.myHolder);
        this.checkFinalFieldAccess(referenceExpression);
        this.checkFinalParameterAccess(referenceExpression);
        if (ResolveUtil.isKeyOfMap(referenceExpression)) {
            PsiElement nameElement = referenceExpression.getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(nameElement).textAttributes(GroovySyntaxHighlighter.MAP_KEY).create();
        } else if (ResolveUtil.isClassReference(referenceExpression)) {
            PsiElement nameElement = referenceExpression.getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(nameElement).textAttributes(GroovySyntaxHighlighter.KEYWORD).create();
        } else if (PsiUtil.isInStaticCompilationContext(referenceExpression)) {
            GroovyUnresolvedAccessChecker.checkUnresolvedReference(referenceExpression, true, true, new UnresolvedReferenceAnnotatorSink(this.myHolder));
        }
    }

    private void checkFinalParameterAccess(GrReferenceExpression ref) {
        GrParameter parameter;
        PsiElement resolved = ref.resolve();
        if (resolved instanceof GrParameter && (parameter = (GrParameter)resolved).isPhysical() && parameter.hasModifierProperty("final") && PsiUtil.isLValue(ref) && parameter.getDeclarationScope() instanceof PsiMethod) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.assign.a.value.to.final.parameter.0", parameter.getName())).create();
        }
    }

    private void checkFinalFieldAccess(@NotNull GrReferenceExpression ref) {
        GrField field;
        PsiClass containingClass;
        PsiElement resolved = ref.resolve();
        if (resolved instanceof GrField && resolved.isPhysical() && ((GrField)resolved).hasModifierProperty("final") && PsiUtil.isLValue(ref) && (containingClass = (field = (GrField)resolved).getContainingClass()) != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true)) {
            GrMember container = GrHighlightUtil.findClassMemberContainer(ref, containingClass);
            if (field.hasModifierProperty("static") ? container instanceof GrClassInitializer && ((GrClassInitializer)container).isStatic() : container instanceof GrMethod && ((GrMethod)container).isConstructor() || container instanceof GrClassInitializer && !((GrClassInitializer)container).isStatic()) {
                return;
            }
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName())).create();
        }
    }

    private void checkStringNameIdentifier(GrReferenceExpression ref) {
        PsiElement nameElement = ref.getReferenceNameElement();
        if (nameElement == null) {
            return;
        }
        IElementType elementType = nameElement.getNode().getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(elementType)) {
            this.checkStringLiteral(nameElement);
        } else if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            this.checkRegexLiteral(nameElement);
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        PsiElement parent2 = typeDefinition.getParent();
        if (!(typeDefinition.isAnonymous() || parent2 instanceof GrTypeDefinitionBody || parent2 instanceof GroovyFile || typeDefinition instanceof GrTypeParameter)) {
            TextRange range = GrHighlightUtil.getClassHeaderTextRange(typeDefinition);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("class.definition.is.not.expected.here", new Object[0])).range(range).withFix((IntentionAction)new GrMoveClassToCorrectPlaceFix(typeDefinition)).create();
        }
        GroovyAnnotator.checkTypeDefinition(this.myHolder, typeDefinition);
        GroovyAnnotator.checkImplementedMethodsOfClass(this.myHolder, typeDefinition);
        GroovyAnnotator.checkConstructors(this.myHolder, typeDefinition);
        GroovyAnnotator.checkAnnotationCollector(this.myHolder, typeDefinition);
        GroovyAnnotator.checkSameNameMethodsWithDifferentAccessModifiers(this.myHolder, typeDefinition.getCodeMethods());
        GroovyAnnotator.checkInheritorOfSelfTypes(this.myHolder, typeDefinition);
    }

    private static void checkInheritorOfSelfTypes(AnnotationHolder holder, GrTypeDefinition definition) {
        if (!(definition instanceof GrClassDefinition)) {
            return;
        }
        List<PsiClass> selfTypeClasses = GrTraitUtil.getSelfTypeClasses(definition);
        for (PsiClass selfClass : selfTypeClasses) {
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)definition, (PsiClass)selfClass, (boolean)true)) continue;
            String message = GroovyBundle.message("selfType.class.does.not.inherit", definition.getQualifiedName(), selfClass.getQualifiedName());
            holder.newAnnotation(HighlightSeverity.ERROR, message).range(GrHighlightUtil.getClassHeaderTextRange(definition)).create();
            break;
        }
    }

    private static void checkSameNameMethodsWithDifferentAccessModifiers(AnnotationHolder holder, GrMethod[] methods) {
        MultiMap map2 = MultiMap.create();
        for (GrMethod method : methods) {
            if (method.isConstructor()) continue;
            map2.putValue((Object)method.getName(), (Object)method);
        }
        for (Map.Entry entry : map2.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            if (collection.size() <= 1 || GroovyAnnotator.sameAccessModifier(collection)) continue;
            for (GrMethod method : collection) {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("mixing.private.and.public.protected.methods.of.the.same.name", new Object[0])).range(GrHighlightUtil.getMethodHeaderTextRange(method)).create();
            }
        }
    }

    private static boolean sameAccessModifier(Collection<GrMethod> collection) {
        Iterator<GrMethod> iterator2 = collection.iterator();
        GrMethod method = iterator2.next();
        boolean privateAccess = "private".equals(VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()));
        while (iterator2.hasNext()) {
            GrMethod next = iterator2.next();
            if (privateAccess == "private".equals(VisibilityUtil.getVisibilityModifier((PsiModifierList)next.getModifierList()))) continue;
            return false;
        }
        return true;
    }

    private static void checkAnnotationCollector(AnnotationHolder holder, GrTypeDefinition definition) {
        if (definition.isAnnotationType() && GrAnnotationCollector.findAnnotationCollector(definition) != null && definition.getCodeMethods().length > 0) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("annotation.collector.cannot.have.attributes", new Object[0])).range(definition.getNameIdentifierGroovy()).create();
        }
    }

    private static void checkConstructors(@NotNull AnnotationHolder holder, @NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition.isEnum() || typeDefinition.isInterface() || typeDefinition.isAnonymous() || typeDefinition instanceof GrTypeParameter) {
            return;
        }
        PsiClass superClass = typeDefinition.getSuperClass();
        if (superClass == null) {
            return;
        }
        if (InheritConstructorContributor.hasInheritConstructorsAnnotation(typeDefinition)) {
            return;
        }
        PsiMethod[] constructors = typeDefinition.getCodeConstructors();
        GroovyAnnotator.checkDefaultConstructors(holder, typeDefinition, superClass, constructors);
        GroovyAnnotator.checkRecursiveConstructors(holder, constructors);
    }

    @Override
    public void visitCallExpression(@NotNull GrCallExpression callExpression) {
        if (callExpression.resolveMethod() == null && callExpression.getFirstChild() instanceof GrLiteral && callExpression.getExpressionArguments().length > 0 && callExpression.getExpressionArguments()[0] instanceof GrLiteral) {
            this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, GroovyBundle.message("inspection.message.cannot.resolve.method.call", new Object[0])).range((PsiElement)callExpression).create();
        }
    }

    private static void checkDefaultConstructors(@NotNull AnnotationHolder holder, @NotNull GrTypeDefinition typeDefinition, @NotNull PsiClass superClass, PsiMethod @NotNull [] constructors) {
        boolean needExplicitSuperCall;
        PsiMethod defConstructor = GroovyAnnotator.getDefaultConstructor(superClass);
        boolean bl = needExplicitSuperCall = superClass.getConstructors().length != 0 && (defConstructor == null || !PsiUtil.isAccessible(typeDefinition, (PsiMember)defConstructor));
        if (!needExplicitSuperCall) {
            return;
        }
        String qName = superClass.getQualifiedName();
        if (!(superClass instanceof GrRecordDefinition) && typeDefinition.getConstructors().length == 0) {
            TextRange range = GrHighlightUtil.getClassHeaderTextRange(typeDefinition);
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("there.is.no.default.constructor.available.in.class.0", qName)).range(range).withFix(QuickFixFactory.getInstance().createCreateConstructorMatchingSuperFix((PsiClass)typeDefinition)).create();
        }
        for (TextRange method : constructors) {
            GrStatement[] statements2;
            GrOpenBlock block;
            if (!(method instanceof GrMethod) || (block = ((GrMethod)method).getBlock()) == null || (statements2 = block.getStatements()).length > 0 && statements2[0] instanceof GrConstructorInvocation) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("there.is.no.default.constructor.available.in.class.0", qName)).range(GrHighlightUtil.getMethodHeaderTextRange((PsiMethod)method)).create();
        }
        List annotations2 = ContainerUtil.filter((Object[])typeDefinition.getAnnotations(), anno -> GrGeneratedConstructorUtils.getConstructorGeneratingAnnotations().contains(anno.getQualifiedName()));
        for (PsiAnnotation anno2 : annotations2) {
            PsiNameValuePair preAttribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)anno2, (String)"pre");
            Object errorRange = preAttribute == null ? GrHighlightUtil.getClassHeaderTextRange(typeDefinition) : (!GeneratedConstructorAnnotationChecker.isSuperCalledInPre(anno2) ? preAttribute.getTextRange() : null);
            if (errorRange == null) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("there.is.no.default.constructor.available.in.class.0", qName)).range(errorRange).create();
        }
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        PsiMethod constructor;
        super.visitEnumConstant(enumConstant);
        GrArgumentList argumentList = enumConstant.getArgumentList();
        if (argumentList != null && PsiImplUtil.hasNamedArguments(argumentList) && !PsiImplUtil.hasExpressionArguments(argumentList) && (constructor = enumConstant.resolveConstructor()) != null && !PsiUtil.isConstructorHasRequiredParameters(constructor)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("the.usage.of.a.map.entry.expression.to.initialize.an.enum.is.currently.not.supported", new Object[0])).range((PsiElement)argumentList).create();
        }
    }

    private static void checkRecursiveConstructors(AnnotationHolder holder, PsiMethod[] constructors) {
        HashMap<PsiMethod, PsiMethod> nodes = new HashMap<PsiMethod, PsiMethod>(constructors.length);
        Set set = ContainerUtil.set((Object[])constructors);
        for (PsiMethod constructor : constructors) {
            PsiMethod resolved;
            GrStatement[] statements2;
            GrOpenBlock block;
            if (!(constructor instanceof GrMethod) || (block = ((GrMethod)constructor).getBlock()) == null || (statements2 = block.getStatements()).length <= 0 || !(statements2[0] instanceof GrConstructorInvocation) || !set.contains(resolved = ((GrConstructorInvocation)statements2[0]).resolveMethod())) continue;
            nodes.put(constructor, resolved);
        }
        HashSet<PsiMethod> checked = new HashSet<PsiMethod>();
        for (PsiMethod constructor : constructors) {
            if (!checked.add(constructor)) continue;
            HashSet<PsiMethod> current = new HashSet<PsiMethod>();
            current.add(constructor);
            constructor = (PsiMethod)nodes.get(constructor);
            while (constructor != null && current.add(constructor)) {
                checked.add(constructor);
                constructor = (PsiMethod)nodes.get(constructor);
            }
            if (constructor == null) continue;
            PsiMethod circleStart = constructor;
            do {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("recursive.constructor.invocation", new Object[0])).range(GrHighlightUtil.getMethodHeaderTextRange(constructor)).create();
            } while ((constructor = (PsiMethod)nodes.get(constructor)) != circleStart);
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
        PsiElement resolved;
        GrTraitTypeDefinition trait;
        GrExpression operand;
        if ((expression.getOperationTokenType() == GroovyTokenTypes.mINC || expression.getOperationTokenType() == GroovyTokenTypes.mDEC) && (operand = expression.getOperand()) instanceof GrReferenceExpression && ((GrReferenceExpression)operand).getQualifier() == null && (trait = (GrTraitTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)operand, GrTraitTypeDefinition.class)) != null && (resolved = ((GrReferenceExpression)operand).resolve()) instanceof GrField && ((GrField)resolved).getContainingClass() instanceof GrTraitTypeDefinition) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("0.expressions.on.trait.fields.properties.are.not.supported.in.traits", expression.getOperationToken().getText())).create();
        }
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        GrMethod method;
        PsiElement blockParent = block.getParent();
        if (blockParent instanceof GrMethod && GrTraitUtil.isMethodAbstract(method = (GrMethod)blockParent)) {
            String message = GroovyBundle.message("abstract.methods.must.not.have.body", new Object[0]);
            AnnotationBuilder builder = this.myHolder.newAnnotation(HighlightSeverity.ERROR, message);
            GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(builder, method, true, message, block.getTextRange()).create();
        }
    }

    @Override
    public void visitField(@NotNull GrField field) {
        super.visitField(field);
        if (field.getTypeElementGroovy() == null && field.getContainingClass() instanceof GrAnnotationTypeDefinition) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("annotation.field.should.have.type.declaration", new Object[0])).range(field.getNameIdentifierGroovy()).create();
        }
        this.checkInitializer(field);
    }

    private void checkInitializer(@NotNull GrField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiAnnotation tupleConstructor = containingClass.getAnnotation("groovy.transform.TupleConstructor");
        if (tupleConstructor == null) {
            return;
        }
        if (!Boolean.FALSE.equals(GrAnnotationUtil.inferBooleanAttribute(tupleConstructor, "defaults"))) {
            return;
        }
        AffectedMembersCache cache2 = GrGeneratedConstructorUtils.getAffectedMembersCache(tupleConstructor);
        if (!cache2.arePropertiesHandledByUser() && cache2.getAffectedMembers().contains(field)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("initializers.are.forbidden.with.defaults", new Object[0])).range((PsiElement)initializer).create();
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        GrOpenBlock block;
        this.checkDuplicateMethod(method);
        GroovyAnnotator.checkMethodWithTypeParamsShouldHaveReturnType(this.myHolder, method);
        GroovyAnnotator.checkInnerMethod(this.myHolder, method);
        GroovyAnnotator.checkOptionalParametersInAbstractMethod(this.myHolder, method);
        GroovyAnnotator.checkConstructorOfImmutableClass(this.myHolder, method);
        GroovyAnnotator.checkGetterOfImmutable(this.myHolder, method);
        PsiElement nameIdentifier = method.getNameIdentifierGroovy();
        if (GroovyTokenSets.STRING_LITERALS.contains(nameIdentifier.getNode().getElementType())) {
            this.checkStringLiteral(nameIdentifier);
        }
        if ((block = method.getBlock()) != null && TypeInferenceHelper.isTooComplexTooAnalyze(block)) {
            this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, GroovyBundle.message("method.0.is.too.complex.too.analyze", method.getName())).range(nameIdentifier).create();
        }
        PsiClass containingClass = method.getContainingClass();
        if (method.isConstructor()) {
            if (containingClass instanceof GrAnonymousClassDefinition) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("constructors.are.not.allowed.in.anonymous.class", new Object[0])).range(nameIdentifier).create();
            } else if (containingClass != null && containingClass.isInterface()) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("constructors.are.not.allowed.in.interface", new Object[0])).range(nameIdentifier).create();
            }
        }
        if (method.getBlock() == null && !method.hasModifierProperty("native") && !GrTraitUtil.isMethodAbstract(method)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("not.abstract.method.should.have.body", new Object[0])).range(nameIdentifier).create();
        }
        GroovyAnnotator.checkOverridingMethod(this.myHolder, method);
    }

    private static void checkGetterOfImmutable(AnnotationHolder holder, GrMethod method) {
        if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        if (!GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)aClass)) {
            return;
        }
        PsiField field = GroovyPropertyUtils.findFieldForAccessor(method, false);
        if (!(field instanceof GrField)) {
            return;
        }
        GrModifierList fieldModifierList = ((GrField)field).getModifierList();
        if (fieldModifierList == null) {
            return;
        }
        if (fieldModifierList.hasExplicitVisibilityModifiers()) {
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("repetitive.method.name.0", method.getName())).range(method.getNameIdentifierGroovy()).create();
    }

    private static void checkConstructorOfImmutableClass(AnnotationHolder holder, GrMethod method) {
        if (!method.isConstructor()) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        if (!GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)aClass)) {
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("explicit.constructors.are.not.allowed.in.immutable.class", new Object[0])).range(method.getNameIdentifierGroovy()).create();
    }

    private static void checkOverridingMethod(@NotNull AnnotationHolder holder, @NotNull GrMethod method) {
        List signatures2 = method.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature signature : signatures2) {
            PsiMethod superMethod = signature.getMethod();
            if (!GrTraitUtil.isTrait(superMethod.getContainingClass()) && superMethod.hasModifierProperty("final")) {
                String current = GroovyPresentationUtil.getSignaturePresentation(method.getSignature(PsiSubstitutor.EMPTY));
                String superPresentation = GroovyPresentationUtil.getSignaturePresentation((MethodSignature)signature);
                String superQName = GroovyAnnotator.getQNameOfMember((PsiMember)superMethod);
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("method.0.cannot.override.method.1.in.2.overridden.method.is.final", current, superPresentation, superQName)).range(GrHighlightUtil.getMethodHeaderTextRange(method)).create();
                return;
            }
            String currentModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
            String superModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)superMethod.getModifierList());
            if ((!"public".equals(superModifier) || !"protected".equals(currentModifier) && !"private".equals(currentModifier)) && (!"protected".equals(superModifier) || !"private".equals(currentModifier))) continue;
            String currentPresentation = GroovyPresentationUtil.getSignaturePresentation(method.getSignature(PsiSubstitutor.EMPTY));
            String superPresentation = GroovyPresentationUtil.getSignaturePresentation((MethodSignature)signature);
            String superQName = GroovyAnnotator.getQNameOfMember((PsiMember)superMethod);
            PsiElement modifier = method.getModifierList().getModifier(currentModifier);
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("method.0.cannot.have.weaker.access.privileges.1.than.2.in.3.4", currentPresentation, currentModifier, superPresentation, superQName, superModifier)).range(modifier != null ? modifier : method.getNameIdentifierGroovy()).create();
        }
    }

    private static void checkMethodWithTypeParamsShouldHaveReturnType(AnnotationHolder holder, GrMethod method) {
        GrTypeElement typeElement;
        PsiTypeParameterList parameterList = method.getTypeParameterList();
        if (parameterList != null && (typeElement = method.getReturnTypeElementGroovy()) == null) {
            TextRange parameterListTextRange = parameterList.getTextRange();
            TextRange range = new TextRange(parameterListTextRange.getEndOffset(), parameterListTextRange.getEndOffset() + 1);
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("method.with.type.parameters.should.have.return.type", new Object[0])).range(range).create();
        }
    }

    private static void checkOptionalParametersInAbstractMethod(AnnotationHolder holder, GrMethod method) {
        if (!method.hasModifierProperty("abstract")) {
            return;
        }
        if (!(method.getContainingClass() instanceof GrInterfaceDefinition)) {
            return;
        }
        for (GrParameter parameter : method.getParameters()) {
            GrExpression initializerGroovy = parameter.getInitializerGroovy();
            if (initializerGroovy == null) continue;
            PsiElement assignOperator = parameter.getNameIdentifierGroovy();
            TextRange textRange = new TextRange(assignOperator.getTextRange().getEndOffset(), initializerGroovy.getTextRange().getEndOffset());
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("default.initializers.are.not.allowed.in.abstract.method", new Object[0])).range(textRange).create();
        }
    }

    @Nullable
    private static PsiMethod getDefaultConstructor(PsiClass clazz) {
        String className = clazz.getName();
        if (className == null) {
            return null;
        }
        PsiMethod[] byName = clazz.findMethodsByName(className, true);
        if (byName.length == 0) {
            return null;
        }
        block0: for (PsiMethod method : byName) {
            GrParameter[] parameters2;
            if (method.getParameterList().isEmpty()) {
                return method;
            }
            if (!(method instanceof GrMethod)) continue;
            for (GrParameter parameter : parameters2 = ((GrMethod)method).getParameterList().getParameters()) {
                if (!parameter.isOptional()) continue block0;
            }
            return method;
        }
        return null;
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        PsiType type2;
        PsiNamedElement duplicate;
        PsiElement delimiter;
        this.checkName(variable);
        PsiElement parent2 = variable.getParent();
        if (parent2 instanceof GrForInClause && (delimiter = ((GrForInClause)parent2).getDelimiter()).getNode().getElementType() == GroovyTokenTypes.mCOLON) {
            GrTypeElement typeElement = variable.getTypeElementGroovy();
            GrModifierList modifierList = variable.getModifierList();
            if (modifierList != null && typeElement == null && StringUtil.isEmptyOrSpaces((String)modifierList.getText())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("java.style.for.each.statement.requires.a.type.declaration", new Object[0])).range(variable.getNameIdentifierGroovy()).withFix((IntentionAction)new ReplaceDelimiterFix()).create();
            }
        }
        if ((duplicate = ResolveUtil.findDuplicate(variable)) instanceof GrVariable && (variable instanceof GrField || ResolveUtil.isScriptField(variable) || !(duplicate instanceof GrField))) {
            String key = duplicate instanceof GrField ? "field.already.defined" : "variable.already.defined";
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message(key, variable.getName())).range(variable.getNameIdentifierGroovy()).create();
        }
        if ((type2 = variable.getDeclaredType()) instanceof PsiEllipsisType && !GroovyAnnotator.isLastParameter(variable)) {
            TextRange range = GroovyAnnotator.getEllipsisRange(variable);
            if (range == null) {
                range = GroovyAnnotator.getTypeRange(variable);
            }
            if (range != null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ellipsis.type.is.not.allowed.here", new Object[0])).range(range).create();
            }
        }
    }

    @Nullable
    private static TextRange getEllipsisRange(GrVariable variable) {
        PsiElement dots;
        if (variable instanceof GrParameter && (dots = ((GrParameter)variable).getEllipsisDots()) != null) {
            return dots.getTextRange();
        }
        return null;
    }

    @Nullable
    private static TextRange getTypeRange(GrVariable variable) {
        GrTypeElement typeElement = variable.getTypeElementGroovy();
        if (typeElement == null) {
            return null;
        }
        PsiElement sibling = typeElement.getNextSibling();
        if (sibling != null && sibling.getNode().getElementType() == GroovyTokenTypes.mTRIPLE_DOT) {
            return new TextRange(typeElement.getTextRange().getStartOffset(), sibling.getTextRange().getEndOffset());
        }
        return typeElement.getTextRange();
    }

    private static boolean isLastParameter(PsiVariable variable) {
        if (!(variable instanceof PsiParameter)) {
            return false;
        }
        PsiElement parent2 = variable.getParent();
        if (!(parent2 instanceof PsiParameterList)) {
            return false;
        }
        PsiParameter[] parameters2 = ((PsiParameterList)parent2).getParameters();
        return parameters2.length > 0 && parameters2[parameters2.length - 1] == variable;
    }

    private void checkName(GrVariable variable) {
        if (!"$".equals(variable.getName())) {
            return;
        }
        this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("incorrect.variable.name", new Object[0])).range(variable.getNameIdentifierGroovy()).create();
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        GrExpression lValue = expression.getLValue();
        if (!PsiUtil.mightBeLValue(lValue)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("invalid.lvalue", new Object[0])).range((PsiElement)lValue).create();
        }
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        GrParameterListOwner owner;
        PsiType type2;
        GrExpression value = returnStatement.getReturnValue();
        if (value != null && (type2 = value.getType()) != null && (owner = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrParameterListOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            if (method.isConstructor()) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.return.from.constructor", new Object[0])).range((PsiElement)value).create();
            } else {
                PsiType methodType = method.getReturnType();
                if (methodType != null && PsiType.VOID.equals((Object)methodType)) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.return.from.void.method", new Object[0])).range((PsiElement)value).create();
                }
            }
        }
    }

    @Override
    public void visitTypeParameterList(@NotNull GrTypeParameterList list) {
        PsiElement parent2 = list.getParent();
        if (parent2 instanceof GrMethod && ((GrMethod)parent2).isConstructor() || parent2 instanceof GrEnumTypeDefinition || parent2 instanceof GrAnnotationTypeDefinition) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("type.parameters.are.unexpected", new Object[0])).create();
        }
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        GroovyConstructorReference constructorReference = listOrMap.getConstructorReference();
        if (constructorReference != null) {
            PsiElement lBracket = listOrMap.getLBrack();
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(lBracket).textAttributes(GroovySyntaxHighlighter.LITERAL_CONVERSION).create();
            PsiElement rBracket = listOrMap.getRBrack();
            if (rBracket != null) {
                this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(rBracket).textAttributes(GroovySyntaxHighlighter.LITERAL_CONVERSION).create();
            }
        }
        GrNamedArgument[] namedArguments = listOrMap.getNamedArguments();
        GrExpression[] expressionArguments = listOrMap.getInitializers();
        if (namedArguments.length != 0 && expressionArguments.length != 0) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("collection.literal.contains.named.argument.and.expression.items", new Object[0])).create();
        }
        this.checkNamedArgs(namedArguments, false);
    }

    @Override
    public void visitClassTypeElement(@NotNull GrClassTypeElement typeElement) {
        GrTypeElement[] elements;
        super.visitClassTypeElement(typeElement);
        GrCodeReferenceElement ref = typeElement.getReferenceElement();
        GrTypeArgumentList argList = ref.getTypeArgumentList();
        if (argList == null) {
            return;
        }
        for (GrTypeElement element : elements = argList.getTypeArgumentElements()) {
            this.checkTypeArgForPrimitive(element, GroovyBundle.message("primitive.type.parameters.are.not.allowed", new Object[0]));
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        PsiElement resolved;
        if (refElement.getParent() instanceof GrAnnotation && (resolved = refElement.resolve()) instanceof PsiClass && !((PsiClass)resolved).isAnnotationType() && GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved) != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(GroovySyntaxHighlighter.ANNOTATION).create();
        }
        ImplKt.checkUnresolvedCodeReference(refElement, this.myHolder);
        ImplKt.checkInnerClassReferenceFromInstanceContext(refElement, this.myHolder);
    }

    @Override
    public void visitTypeElement(@NotNull GrTypeElement typeElement) {
        PsiElement parent2 = typeElement.getParent();
        if (!(parent2 instanceof GrMethod)) {
            return;
        }
        if (parent2 instanceof GrAnnotationMethod) {
            GroovyAnnotator.checkAnnotationAttributeType(typeElement, this.myHolder);
        } else if (((GrMethod)parent2).isConstructor()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("constructors.cannot.have.return.type", new Object[0])).create();
        } else {
            GroovyAnnotator.checkMethodReturnType((GrMethod)parent2, typeElement, this.myHolder);
        }
    }

    @Override
    public void visitArrayTypeElement(@NotNull GrArrayTypeElement typeElement) {
        GrTypeElement componentTypeElement = typeElement.getComponentTypeElement();
        PsiType componentType = componentTypeElement.getType();
        if (PsiType.VOID.equals((Object)componentType)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.type.void", new Object[0])).range((PsiElement)componentTypeElement).create();
        } else {
            super.visitArrayTypeElement(typeElement);
        }
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        PsiElement parent2 = modifierList.getParent();
        if (parent2 instanceof GrMethod) {
            GroovyAnnotator.checkMethodDefinitionModifiers(this.myHolder, (GrMethod)parent2);
        } else if (parent2 instanceof GrVariableDeclaration) {
            GrVariableDeclaration declaration = (GrVariableDeclaration)parent2;
            if (ResolveUtil.isFieldDeclaration(declaration)) {
                GroovyAnnotator.checkFieldModifiers(this.myHolder, declaration);
            } else {
                UtilKt.checkVariableModifiers(this.myHolder, declaration);
            }
        } else if (parent2 instanceof GrClassInitializer) {
            GroovyAnnotator.checkClassInitializerModifiers(this.myHolder, modifierList);
        }
    }

    private static void checkClassInitializerModifiers(AnnotationHolder holder, GrModifierList modifierList) {
        for (GrAnnotation annotation : modifierList.getAnnotations()) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("initializer.cannot.have.annotations", new Object[0])).range((PsiElement)annotation).create();
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if ("static".equals(modifier)) continue;
            UtilKt.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("initializer.cannot.be.0", modifier), holder);
        }
    }

    @Override
    public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
        PsiClass aClass = initializer.getContainingClass();
        if (GrTraitUtil.isInterface(aClass)) {
            TextRange range = GrHighlightUtil.getInitializerHeaderTextRange(initializer);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("initializers.are.not.allowed.in.interface", new Object[0])).range(range).create();
        }
    }

    private static void checkFieldModifiers(AnnotationHolder holder, GrVariableDeclaration fieldDeclaration) {
        GrField member;
        GrVariable[] variables = fieldDeclaration.getVariables();
        if (variables.length == 0) {
            return;
        }
        GrVariable variable = variables[0];
        GrField grField = member = variable instanceof GrField ? (GrField)variable : ResolveUtil.findScriptField(variable);
        if (member == null) {
            return;
        }
        GrModifierList modifierList = fieldDeclaration.getModifierList();
        GroovyAnnotator.checkAccessModifiers(holder, modifierList, member);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifierList, member);
        if (modifierList.hasExplicitModifier("volatile") && modifierList.hasExplicitModifier("final")) {
            String message = GroovyBundle.message("illegal.combination.of.modifiers.volatile.and.final", new Object[0]);
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)modifierList);
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "volatile", true, false, GrModifierFix.MODIFIER_LIST), modifierList, message, ProblemHighlightType.ERROR, modifierList.getTextRange());
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "final", true, false, GrModifierFix.MODIFIER_LIST), modifierList, message, ProblemHighlightType.ERROR, modifierList.getTextRange());
            builder.create();
        }
        if (member.getContainingClass() instanceof GrInterfaceDefinition) {
            UtilKt.checkModifierIsNotAllowed(modifierList, "private", GroovyBundle.message("interface.members.are.not.allowed.to.be", "private"), holder);
            UtilKt.checkModifierIsNotAllowed(modifierList, "protected", GroovyBundle.message("interface.members.are.not.allowed.to.be", "protected"), holder);
        }
    }

    private static void checkAnnotationAttributeType(GrTypeElement element, AnnotationHolder holder) {
        PsiElement resolved;
        if (element instanceof GrBuiltInTypeElement) {
            return;
        }
        if (element instanceof GrArrayTypeElement) {
            GroovyAnnotator.checkAnnotationAttributeType(((GrArrayTypeElement)element).getComponentTypeElement(), holder);
            return;
        }
        if (element instanceof GrClassTypeElement && (resolved = ((GrClassTypeElement)element).getReferenceElement().resolve()) instanceof PsiClass) {
            if ("java.lang.String".equals(((PsiClass)resolved).getQualifiedName())) {
                return;
            }
            if ("java.lang.Class".equals(((PsiClass)resolved).getQualifiedName())) {
                return;
            }
            if (((PsiClass)resolved).isAnnotationType()) {
                return;
            }
            if (((PsiClass)resolved).isEnum()) {
                return;
            }
        }
        holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unexpected.attribute.type.0", element.getType())).range((PsiElement)element).create();
    }

    static void checkMethodReturnType(PsiMethod method, PsiElement toHighlight, AnnotationHolder holder) {
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        List superSignatures = signature.getSuperSignatures();
        PsiType returnType2 = signature.getSubstitutor().substitute(method.getReturnType());
        for (HierarchicalMethodSignature superMethodSignature : superSignatures) {
            String highlightInfo;
            PsiClass superClass;
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiType declaredReturnType = superMethod.getReturnType();
            PsiType superReturnType = superMethodSignature.getSubstitutor().substitute(declaredReturnType);
            if (PsiType.VOID.equals((Object)superReturnType) && method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null) {
                return;
            }
            if (superMethodSignature.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType2 == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null || (highlightInfo = GroovyAnnotator.checkSuperMethodSignature(superMethod, (MethodSignatureBackedByPsiMethod)superMethodSignature, superReturnType, method, (MethodSignatureBackedByPsiMethod)signature, returnType2)) == null) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, highlightInfo).range(toHighlight).create();
            return;
        }
    }

    @Nullable
    @InspectionMessage
    private static String checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType2) {
        PsiType substitutedSuperReturnType = GroovyAnnotator.substituteSuperReturnType(superMethodSignature, methodSignature, superReturnType);
        if (returnType2.equals(substitutedSuperReturnType)) {
            return null;
        }
        PsiType rawReturnType = TypeConversionUtil.erasure((PsiType)returnType2);
        PsiType rawSuperReturnType = TypeConversionUtil.erasure((PsiType)substitutedSuperReturnType);
        if (returnType2 instanceof PsiClassType && substitutedSuperReturnType instanceof PsiClassType ? TypeConversionUtil.isAssignable((PsiType)rawSuperReturnType, (PsiType)rawReturnType) : returnType2 instanceof PsiArrayType && superReturnType instanceof PsiArrayType && rawReturnType.equals(rawSuperReturnType)) {
            return null;
        }
        String qName = GroovyAnnotator.getQNameOfMember((PsiMember)method);
        String baseQName = GroovyAnnotator.getQNameOfMember((PsiMember)superMethod);
        String presentation = returnType2.getCanonicalText() + " " + GroovyPresentationUtil.getSignaturePresentation((MethodSignature)methodSignature);
        String basePresentation = superReturnType.getCanonicalText() + " " + GroovyPresentationUtil.getSignaturePresentation((MethodSignature)superMethodSignature);
        return GroovyBundle.message("return.type.is.incompatible", presentation, qName, basePresentation, baseQName);
    }

    @NotNull
    private static PsiType substituteSuperReturnType(@NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType superReturnType) {
        PsiSubstitutor unifyingSubstitutor;
        PsiType substitutedSuperReturnType = !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superMethodSignature.getSubstitutor().substitute(superReturnType))) : TypeConversionUtil.erasure((PsiType)superReturnType);
        return substitutedSuperReturnType;
    }

    @NotNull
    @NlsSafe
    private static String getQNameOfMember(@NotNull PsiMember member) {
        PsiClass aClass = member.getContainingClass();
        return GroovyAnnotator.getQName(aClass);
    }

    @NotNull
    @NlsSafe
    private static String getQName(@Nullable PsiClass aClass) {
        String qname;
        if (aClass instanceof PsiAnonymousClass) {
            return GroovyBundle.message("anonymous.class.derived.from.0", ((PsiAnonymousClass)aClass).getBaseClassType().getCanonicalText());
        }
        if (aClass != null && (qname = aClass.getQualifiedName()) != null) {
            return qname;
        }
        return "<null>";
    }

    private void checkTypeArgForPrimitive(@Nullable GrTypeElement element, @NotNull @InspectionMessage String message) {
        if (element == null || !(element.getType() instanceof PsiPrimitiveType)) {
            return;
        }
        AnnotationBuilder builder = this.myHolder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)element);
        builder = UtilKt.registerLocalFix(builder, new GrReplacePrimitiveTypeWithWrapperFix(element), element, message, ProblemHighlightType.ERROR, element.getTextRange());
        builder.create();
    }

    @Override
    public void visitWildcardTypeArgument(@NotNull GrWildcardTypeArgument wildcardTypeArgument) {
        super.visitWildcardTypeArgument(wildcardTypeArgument);
        this.checkTypeArgForPrimitive(wildcardTypeArgument.getBoundTypeElement(), GroovyBundle.message("primitive.bound.types.are.not.allowed", new Object[0]));
    }

    private void highlightNamedArgs(GrNamedArgument[] namedArguments) {
        for (GrNamedArgument namedArgument : namedArguments) {
            GrArgumentLabel label = namedArgument.getLabel();
            if (label == null || label.getExpression() != null || label.getNameElement().getNode().getElementType() == GroovyTokenTypes.mSTAR) continue;
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)label).textAttributes(GroovySyntaxHighlighter.MAP_KEY).create();
        }
    }

    private void checkNamedArgs(GrNamedArgument[] namedArguments, boolean forArgList) {
        this.highlightNamedArgs(namedArguments);
        HashSet<Object> existingKeys = new HashSet<Object>();
        for (GrNamedArgument namedArgument : namedArguments) {
            GrArgumentLabel label = namedArgument.getLabel();
            Object value = PsiUtil.getLabelValue(label);
            if (value == null) continue;
            if (value == ObjectUtils.NULL) {
                value = null;
            }
            if (existingKeys.add(value)) continue;
            if (forArgList) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("duplicated.named.parameter", String.valueOf(value))).range((PsiElement)label).create();
                continue;
            }
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("duplicate.element.in.the.map", String.valueOf(value))).range((PsiElement)label).create();
        }
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        PsiClass clazz;
        GrTypeElement typeElement;
        GrTypeArgumentList constructorTypeArguments = newExpression.getConstructorTypeArguments();
        if (constructorTypeArguments != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("groovy.does.not.support.constructor.type.arguments", new Object[0])).range((PsiElement)constructorTypeArguments).create();
        }
        if ((typeElement = newExpression.getTypeElement()) instanceof GrBuiltInTypeElement && newExpression.getArrayCount() == 0) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("create.instance.of.built-in.type", new Object[0])).range((PsiElement)typeElement).create();
        }
        if (newExpression.getArrayCount() > 0) {
            return;
        }
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement == null) {
            return;
        }
        PsiElement element = refElement.resolve();
        if (element instanceof PsiClass && (clazz = (PsiClass)element).hasModifierProperty("abstract") && newExpression.getAnonymousClassDefinition() == null) {
            String message = clazz.isInterface() ? GroovyBundle.message("cannot.instantiate.interface", clazz.getName()) : GroovyBundle.message("cannot.instantiate.abstract.class", clazz.getName());
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)refElement).create();
        }
    }

    @Override
    public void visitArgumentList(@NotNull GrArgumentList list) {
        this.checkNamedArgs(list.getNamedArguments(), true);
    }

    @Override
    public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
        GroovyAnnotator.checkFlowInterruptStatement(breakStatement, this.myHolder);
    }

    @Override
    public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
        GroovyAnnotator.checkFlowInterruptStatement(continueStatement, this.myHolder);
    }

    @Override
    public void visitPackageDefinition(@NotNull GrPackageDefinition packageDefinition) {
        GrModifierList modifierList = packageDefinition.getAnnotationList();
        GroovyAnnotator.checkAnnotationList(this.myHolder, modifierList, GroovyBundle.message("package.definition.cannot.have.modifiers", new Object[0]));
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        super.visitLambdaExpression(expression);
        PsiElement arrow = expression.getArrow();
        this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(arrow).textAttributes(GroovySyntaxHighlighter.LAMBDA_ARROW_AND_BRACES).create();
    }

    @Override
    public void visitBlockLambdaBody(@NotNull GrBlockLambdaBody body) {
        PsiElement rBrace;
        super.visitBlockLambdaBody(body);
        PsiElement lBrace = body.getLBrace();
        if (lBrace != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(lBrace).textAttributes(GroovySyntaxHighlighter.LAMBDA_ARROW_AND_BRACES).create();
        }
        if ((rBrace = body.getRBrace()) != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(rBrace).textAttributes(GroovySyntaxHighlighter.LAMBDA_ARROW_AND_BRACES).create();
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        PsiElement closureArrow;
        super.visitClosure(closure);
        this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(closure.getLBrace()).textAttributes(GroovySyntaxHighlighter.CLOSURE_ARROW_AND_BRACES).create();
        PsiElement rBrace = closure.getRBrace();
        if (rBrace != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(rBrace).textAttributes(GroovySyntaxHighlighter.CLOSURE_ARROW_AND_BRACES).create();
        }
        if ((closureArrow = closure.getArrow()) != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(closureArrow).textAttributes(GroovySyntaxHighlighter.CLOSURE_ARROW_AND_BRACES).create();
        }
        if (!FunctionalExpressionFlowUtil.isFlatDFAAllowed() && TypeInferenceHelper.isTooComplexTooAnalyze(closure)) {
            int endOffset;
            int startOffset = closure.getTextRange().getStartOffset();
            PsiElement arrow = closure.getArrow();
            if (arrow != null) {
                endOffset = arrow.getTextRange().getEndOffset();
            } else {
                Document document = PsiDocumentManager.getInstance((Project)closure.getProject()).getDocument(closure.getContainingFile());
                if (document == null) {
                    return;
                }
                String text = document.getText();
                endOffset = Math.min(closure.getTextRange().getEndOffset(), text.indexOf(10, startOffset));
            }
            this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, GroovyBundle.message("closure.is.too.complex.to.analyze", new Object[0])).range(new TextRange(startOffset, endOffset)).create();
        }
    }

    @Override
    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        IElementType elementType = literal.getFirstChild().getNode().getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(elementType)) {
            this.checkStringLiteral(literal);
        } else if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            this.checkRegexLiteral(literal.getFirstChild());
        }
    }

    @Override
    public void visitRegexExpression(@NotNull GrRegex regex) {
        this.checkRegexLiteral(regex);
    }

    private void checkRegexLiteral(PsiElement regex) {
        String[] parts = regex instanceof GrRegex ? ((GrRegex)regex).getTextParts() : new String[]{regex.getFirstChild().getNextSibling().getText()};
        for (String part : parts) {
            if (GrStringUtil.parseRegexCharacters(part, new StringBuilder(part.length()), null, regex.getText().startsWith("/"))) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.escape.character.in.string.literal", new Object[0])).range(regex).create();
            return;
        }
    }

    @Override
    public void visitGStringExpression(@NotNull GrString gstring) {
        for (GrStringContent part : gstring.getContents()) {
            String text = part.getText();
            if (GrStringUtil.parseStringCharacters(text, new StringBuilder(text.length()), null)) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.escape.character.in.string.literal", new Object[0])).range((PsiElement)part).create();
            return;
        }
    }

    @Override
    public void visitGStringInjection(@NotNull GrStringInjection injection) {
        PsiElement lineFeed;
        if (((GrString)injection.getParent()).isPlainString() && (lineFeed = StringInjectionKt.getLineFeed(injection)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("injection.should.not.contain.line.feeds", new Object[0])).range(lineFeed).create();
        }
    }

    private void checkStringLiteral(PsiElement literal) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)literal.getProject());
        String text = injectedLanguageManager.isInjectedFragment(literal.getContainingFile()) ? injectedLanguageManager.getUnescapedText(literal) : literal.getText();
        assert (text != null);
        StringBuilder builder = new StringBuilder(text.length());
        String quote = GrStringUtil.getStartQuote(text);
        if (quote.isEmpty()) {
            return;
        }
        String substring = text.substring(quote.length());
        if (!GrStringUtil.parseStringCharacters(substring, new StringBuilder(text.length()), null)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.escape.character.in.string.literal", new Object[0])).range(literal).create();
            return;
        }
        int[] offsets = new int[substring.length() + 1];
        boolean result2 = GrStringUtil.parseStringCharacters(substring, builder, offsets);
        LOG.assertTrue(result2);
        if (!builder.toString().endsWith(quote) || substring.charAt(offsets[builder.length() - quote.length()]) == '\\') {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("string.end.expected", new Object[0])).create();
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        PsiElement[] modifiers;
        GrVariable var = forInClause.getDeclaredVariable();
        if (var == null) {
            return;
        }
        GrModifierList modifierList = var.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (PsiElement modifier : modifiers = modifierList.getModifiers()) {
            String modifierText;
            if (modifier instanceof PsiAnnotation || "final".equals(modifierText = modifier.getText()) || "def".equals(modifierText)) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("not.allowed.modifier.in.for.in", modifierText)).range(modifier).create();
        }
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        PsiClass scriptClass = file.getScriptClass();
        if (scriptClass != null) {
            GroovyAnnotator.checkSameNameMethodsWithDifferentAccessModifiers(this.myHolder, file.getMethods());
        }
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        AnnotationChecker.checkApplicability(annotation, annotation.getOwner(), this.myHolder, annotation.getClassReference());
    }

    @Override
    public void visitAnnotationArgumentList(@NotNull GrAnnotationArgumentList annotationArgumentList) {
        GrAnnotation parent2 = (GrAnnotation)annotationArgumentList.getParent();
        Pair<PsiElement, @InspectionMessage String> r = AnnotationChecker.checkAnnotationArgumentList(parent2, this.myHolder);
        if (r != null && r.getFirst() != null && r.getSecond() != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, (String)r.getSecond()).range((PsiElement)r.getFirst()).create();
        }
    }

    @Override
    public void visitAnnotationMethod(@NotNull GrAnnotationMethod annotationMethod) {
        GrAnnotationMemberValue value;
        super.visitAnnotationMethod(annotationMethod);
        PsiReferenceList list = annotationMethod.getThrowsList();
        if (list.getReferencedTypes().length > 0) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("throws.clause.is.not.allowed.in.at.interface", new Object[0])).range((PsiElement)list).create();
        }
        if ((value = annotationMethod.getDefaultValue()) == null) {
            return;
        }
        PsiType type2 = annotationMethod.getReturnType();
        // Could not load outer class - annotation placement on inner may be incorrect
        Pair.NonNull<PsiElement, @InspectionMessage String> result2 = CustomAnnotationChecker.checkAnnotationValueByType(value, type2, false);
        if (result2 != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, (String)result2.getSecond()).range((PsiElement)result2.getFirst()).create();
        }
    }

    @Override
    public void visitAnnotationNameValuePair(@NotNull GrAnnotationNameValuePair nameValuePair) {
        GrAnnotationMemberValue value;
        int count;
        PsiElement parent2;
        PsiElement identifier = nameValuePair.getNameIdentifierGroovy();
        if (identifier == null && (parent2 = nameValuePair.getParent()) instanceof GrAnnotationArgumentList && (count = ((GrAnnotationArgumentList)parent2).getAttributes().length) > 1) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("attribute.name.expected", new Object[0])).create();
        }
        if ((value = nameValuePair.getValue()) != null) {
            this.checkAnnotationAttributeValue(value, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAnnotationAttributeValue(@Nullable GrAnnotationMemberValue value, @NotNull PsiElement toHighlight) {
        IElementType iElementType;
        if (value == null) {
            return false;
        }
        if (value instanceof GrLiteral) {
            return false;
        }
        if (value instanceof GrFunctionalExpression) {
            return false;
        }
        if (value instanceof GrAnnotation) {
            return false;
        }
        if (value instanceof GrReferenceExpression) {
            void var3_5;
            PsiElement psiElement = ((GrReferenceExpression)value).resolve();
            if (psiElement instanceof PsiClass) {
                return false;
            }
            if (psiElement instanceof PsiEnumConstant) {
                return false;
            }
            if (psiElement == null && GroovyAnnotator.isClassReference(value)) {
                return false;
            }
            if (psiElement instanceof GrAccessorMethod) {
                GrField grField = ((GrAccessorMethod)psiElement).getProperty();
            }
            if (var3_5 instanceof PsiField) {
                GrExpression initializer;
                try {
                    PsiExpression _initializer;
                    initializer = var3_5 instanceof GrField ? ((GrField)var3_5).getInitializerGroovy() : ((_initializer = ((PsiField)var3_5).getInitializer()) != null ? (GrExpression)ExpressionConverter.getExpression((PsiElement)_initializer, (Language)GroovyLanguage.INSTANCE, (Project)value.getProject()) : null);
                }
                catch (IncorrectOperationException e) {
                    initializer = null;
                }
                if (initializer != null) {
                    return this.checkAnnotationAttributeValue(initializer, toHighlight);
                }
            }
        }
        if (value instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue expression : ((GrAnnotationArrayInitializer)value).getInitializers()) {
                if (!this.checkAnnotationAttributeValue(expression, toHighlight)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof GrUnaryExpression && ((iElementType = ((GrUnaryExpression)value).getOperationTokenType()) == GroovyTokenTypes.mMINUS || iElementType == GroovyTokenTypes.mPLUS)) {
            return this.checkAnnotationAttributeValue(((GrUnaryExpression)value).getOperand(), toHighlight);
        }
        this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("expected.0.to.be.inline.constant", value.getText())).range(toHighlight).create();
        return true;
    }

    private static boolean isClassReference(GrAnnotationMemberValue value) {
        PsiElement resolved;
        GrExpression qualifier;
        String referenceName;
        return value instanceof GrReferenceExpression && "class".equals(referenceName = ((GrReferenceExpression)value).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)value).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass;
    }

    @Override
    public void visitImportStatement(@NotNull GrImportStatement importStatement) {
        GroovyAnnotator.checkAnnotationList(this.myHolder, importStatement.getAnnotationList(), GroovyBundle.message("import.statement.cannot.have.modifiers", new Object[0]));
    }

    @Override
    public void visitExtendsClause(@NotNull GrExtendsClause extendsClause) {
        GrTypeDefinition typeDefinition = (GrTypeDefinition)extendsClause.getParent();
        if (typeDefinition.isAnnotationType()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("annotation.types.may.not.have.extends.clause", new Object[0])).create();
        } else if (typeDefinition.isTrait()) {
            GroovyAnnotator.checkReferenceList(this.myHolder, extendsClause, IS_TRAIT, GroovyBundle.message("only.traits.expected.here", new Object[0]), null);
        } else if (typeDefinition.isInterface()) {
            GroovyAnnotator.checkReferenceList(this.myHolder, extendsClause, IS_INTERFACE, GroovyBundle.message("no.class.expected.here", new Object[0]), null);
        } else if (typeDefinition.isEnum()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("enums.may.not.have.extends.clause", new Object[0])).create();
        } else {
            GroovyAnnotator.checkReferenceList(this.myHolder, extendsClause, IS_NOT_INTERFACE, GroovyBundle.message("no.interface.expected.here", new Object[0]), new ChangeExtendsImplementsQuickFix(typeDefinition));
            GroovyAnnotator.checkForWildCards(this.myHolder, extendsClause);
        }
    }

    @Override
    public void visitImplementsClause(@NotNull GrImplementsClause implementsClause) {
        GrTypeDefinition typeDefinition = (GrTypeDefinition)implementsClause.getParent();
        if (typeDefinition.isAnnotationType()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("annotation.types.may.not.have.implements.clause", new Object[0])).create();
        } else if (GrTraitUtil.isInterface(typeDefinition)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("no.implements.clause.allowed.for.interface", new Object[0])).withFix((IntentionAction)new ChangeExtendsImplementsQuickFix(typeDefinition)).create();
        } else {
            GroovyAnnotator.checkReferenceList(this.myHolder, implementsClause, IS_INTERFACE, GroovyBundle.message("no.class.expected.here", new Object[0]), typeDefinition instanceof GrRecordDefinition ? null : new ChangeExtendsImplementsQuickFix(typeDefinition));
            GroovyAnnotator.checkForWildCards(this.myHolder, implementsClause);
        }
    }

    private static void checkReferenceList(@NotNull AnnotationHolder holder, @NotNull GrReferenceList list, @NotNull Condition<? super PsiClass> applicabilityCondition, @NotNull @InspectionMessage String message, @Nullable IntentionAction fix) {
        for (GrCodeReferenceElement refElement : list.getReferenceElementsGroovy()) {
            PsiElement psiClass = refElement.resolve();
            if (!(psiClass instanceof PsiClass) || applicabilityCondition.value((Object)((PsiClass)psiClass))) continue;
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)refElement);
            if (fix != null) {
                builder = builder.withFix(fix);
            }
            builder.create();
        }
    }

    private static void checkFlowInterruptStatement(GrFlowInterruptingStatement statement, AnnotationHolder holder) {
        GrStatement targetStatement;
        GrLabeledStatement resolved;
        PsiElement label = statement.getLabelIdentifier();
        if (label != null && (resolved = statement.resolveLabel()) == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("undefined.label", statement.getLabelName())).range(label).create();
        }
        if ((targetStatement = statement.findTargetStatement()) == null) {
            if (statement instanceof GrContinueStatement && label == null) {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("continue.outside.loop", new Object[0])).create();
            } else if (statement instanceof GrBreakStatement && label == null) {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("break.outside.loop.or.switch", new Object[0])).create();
            }
        }
        if (statement instanceof GrBreakStatement && label != null && GroovyAnnotator.findFirstLoop(statement) == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("break.outside.loop", new Object[0])).create();
        }
    }

    @Nullable
    private static GrLoopStatement findFirstLoop(GrFlowInterruptingStatement statement) {
        return (GrLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GrLoopStatement.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class, GrMember.class, GroovyFile.class});
    }

    private static void checkThisOrSuperReferenceExpression(GrReferenceExpression ref, AnnotationHolder holder) {
        GrMember container;
        PsiElement nameElement = ref.getReferenceNameElement();
        if (nameElement == null) {
            return;
        }
        IElementType elementType = nameElement.getNode().getElementType();
        if (elementType != GroovyTokenTypes.kSUPER && elementType != GroovyTokenTypes.kTHIS) {
            return;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
            if (resolved instanceof PsiClass) {
                Object[] superTypes;
                GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)ref, GrTypeDefinition.class, (boolean)true, (Class[])new Class[]{GroovyFile.class});
                if (elementType == GroovyTokenTypes.kSUPER && containingClass != null && GrTraitUtil.isTrait((PsiClass)resolved) && ContainerUtil.find((Object[])(superTypes = containingClass.getSuperTypes()), type2 -> ref.getManager().areElementsEquivalent((PsiElement)type2.resolve(), resolved)) != null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(nameElement).textAttributes(GroovySyntaxHighlighter.KEYWORD).create();
                    return;
                }
                if (containingClass == null || containingClass.getContainingClass() == null && !containingClass.isAnonymous()) {
                    holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("qualified.0.is.allowed.only.in.nested.or.inner.classes", nameElement.getText())).create();
                    return;
                }
                if (!PsiTreeUtil.isAncestor((PsiElement)resolved, (PsiElement)ref, (boolean)true)) {
                    String qname = ((PsiClass)resolved).getQualifiedName();
                    assert (qname != null);
                    holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("is.not.enclosing.class", qname)).create();
                }
            }
        } else if (qualifier == null && elementType == GroovyTokenTypes.kSUPER && (container = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{GrMethod.class, GrClassInitializer.class})) != null && container.hasModifierProperty("static")) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("super.cannot.be.used.in.static.context", new Object[0])).create();
        }
    }

    private static void checkGrDocReferenceElement(AnnotationHolder holder, PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && TokenSets.BUILT_IN_TYPES.contains(node.getElementType())) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(GroovySyntaxHighlighter.KEYWORD).create();
        }
    }

    private static void checkAnnotationList(AnnotationHolder holder, @NotNull GrModifierList modifierList, @NotNull @InspectionMessage String message) {
        PsiElement[] modifiers;
        for (PsiElement modifier : modifiers = modifierList.getModifiers()) {
            if (modifier instanceof PsiAnnotation) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, message).range(modifier).create();
        }
    }

    private static void checkImplementedMethodsOfClass(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        if (typeDefinition.hasModifierProperty("abstract")) {
            return;
        }
        if (typeDefinition.isAnnotationType()) {
            return;
        }
        if (typeDefinition instanceof GrTypeParameter) {
            return;
        }
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)typeDefinition);
        if (abstractMethod == null) {
            return;
        }
        String notImplementedMethodName = abstractMethod.getName();
        TextRange range = GrHighlightUtil.getClassHeaderTextRange(typeDefinition);
        String message = GroovyBundle.message("method.is.not.implemented", notImplementedMethodName);
        AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(range);
        GroovyAnnotator.registerImplementsMethodsFix(typeDefinition, abstractMethod, builder, message, range).create();
    }

    @Contract(pure=true)
    private static AnnotationBuilder registerImplementsMethodsFix(@NotNull GrTypeDefinition typeDefinition, @NotNull PsiMethod abstractMethod, @NotNull AnnotationBuilder builder, @InspectionMessage String message, TextRange range) {
        if (!OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)typeDefinition, (boolean)true).isEmpty()) {
            builder = builder.withFix((IntentionAction)QuickFixFactory.getInstance().createImplementMethodsFix((PsiClass)typeDefinition));
        }
        if (!JavaPsiFacade.getInstance((Project)typeDefinition.getProject()).getResolveHelper().isAccessible((PsiMember)abstractMethod, (PsiElement)typeDefinition, null)) {
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix((PsiMember)abstractMethod, "public", true, true, GrModifierFix.MODIFIER_LIST_OWNER), (PsiElement)abstractMethod, message, ProblemHighlightType.ERROR, range);
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix((PsiMember)abstractMethod, "protected", true, true, GrModifierFix.MODIFIER_LIST_OWNER), (PsiElement)abstractMethod, message, ProblemHighlightType.ERROR, range);
        }
        if (!(typeDefinition instanceof GrAnnotationTypeDefinition) && typeDefinition.getModifierList() != null) {
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix(typeDefinition, "abstract", false, true, GrModifierFix.MODIFIER_LIST_OWNER), typeDefinition, message, ProblemHighlightType.ERROR, range);
        }
        return builder;
    }

    private static void checkInnerMethod(AnnotationHolder holder, GrMethod grMethod) {
        PsiElement parent2 = grMethod.getParent();
        if (parent2 instanceof GrOpenBlock || parent2 instanceof GrClosableBlock || parent2 instanceof GrBlockLambdaBody) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("Inner.methods.are.not.supported", new Object[0])).range(grMethod.getNameIdentifierGroovy()).create();
        }
    }

    @NotNull
    @Contract(pure=true)
    private static AnnotationBuilder registerMakeAbstractMethodNotAbstractFix(AnnotationBuilder builder, GrMethod method, boolean makeClassAbstract, @InspectionMessage String message, TextRange range) {
        PsiModifierList list;
        PsiClass containingClass;
        builder = method.getBlock() == null ? builder.withFix(QuickFixFactory.getInstance().createAddMethodBodyFix((PsiMethod)method)) : builder.withFix(QuickFixFactory.getInstance().createDeleteMethodBodyFix((PsiMethod)method));
        GrModifierFix fix = new GrModifierFix(method, "abstract", false, false, GrModifierFix.MODIFIER_LIST_OWNER);
        builder = UtilKt.registerLocalFix(builder, fix, method, message, ProblemHighlightType.ERROR, range);
        if (makeClassAbstract && (containingClass = method.getContainingClass()) != null && (list = containingClass.getModifierList()) != null && !list.hasModifierProperty("abstract")) {
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix((PsiMember)containingClass, "abstract", false, true, GrModifierFix.MODIFIER_LIST_OWNER), (PsiElement)containingClass, message, ProblemHighlightType.ERROR, range);
        }
        return builder;
    }

    private static void checkMethodDefinitionModifiers(AnnotationHolder holder, GrMethod method) {
        AnnotationBuilder builder;
        String message;
        GrModifierList modifiersList = method.getModifierList();
        GroovyAnnotator.checkAccessModifiers(holder, modifiersList, method);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifiersList, method);
        GroovyAnnotator.checkOverrideAnnotation(holder, modifiersList, method);
        UtilKt.checkModifierIsNotAllowed(modifiersList, "volatile", GroovyBundle.message("method.has.incorrect.modifier.volatile", new Object[0]), holder);
        GroovyAnnotator.checkForAbstractAndFinalCombination(holder, method, modifiersList);
        boolean isMethodAbstract = modifiersList.hasExplicitModifier("abstract");
        PsiElement modifierOrList = GroovyAnnotator.getModifierOrList(modifiersList, "abstract");
        if (method.getParent() instanceof GroovyFileBase) {
            if (isMethodAbstract) {
                message = GroovyBundle.message("script.method.cannot.have.modifier.abstract", new Object[0]);
                AnnotationBuilder builder2 = holder.newAnnotation(HighlightSeverity.ERROR, message).range(modifierOrList);
                GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(builder2, method, false, message, modifierOrList.getTextRange()).create();
            }
            UtilKt.checkModifierIsNotAllowed(modifiersList, "native", GroovyBundle.message("script.cannot.have.modifier.native", new Object[0]), holder);
        } else if (method.getParent() != null && method.getParent().getParent() instanceof GrTypeDefinition) {
            GrTypeDefinition containingTypeDef = (GrTypeDefinition)method.getParent().getParent();
            if (containingTypeDef.isTrait()) {
                UtilKt.checkModifierIsNotAllowed(modifiersList, "protected", GroovyBundle.message("trait.method.cannot.be.protected", new Object[0]), holder);
            } else if (containingTypeDef.isInterface()) {
                UtilKt.checkModifierIsNotAllowed(modifiersList, "static", GroovyBundle.message("interface.must.have.no.static.method", new Object[0]), holder);
                UtilKt.checkModifierIsNotAllowed(modifiersList, "private", GroovyBundle.message("interface.members.are.not.allowed.to.be", "private"), holder);
                UtilKt.checkModifierIsNotAllowed(modifiersList, "protected", GroovyBundle.message("interface.members.are.not.allowed.to.be", "protected"), holder);
            } else if (containingTypeDef.isAnonymous()) {
                if (isMethodAbstract) {
                    String message2 = GroovyBundle.message("anonymous.class.cannot.have.abstract.method", new Object[0]);
                    builder = holder.newAnnotation(HighlightSeverity.ERROR, message2).range(modifierOrList);
                    GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(builder, method, false, message2, modifierOrList.getTextRange()).create();
                }
            } else {
                GrModifierList typeDefModifiersList = containingTypeDef.getModifierList();
                LOG.assertTrue(typeDefModifiersList != null, (Object)"modifiers list must be not null");
                if (!typeDefModifiersList.hasModifierProperty("abstract") && isMethodAbstract) {
                    String message3 = GroovyBundle.message("only.abstract.class.can.have.abstract.method", new Object[0]);
                    AnnotationBuilder builder3 = holder.newAnnotation(HighlightSeverity.ERROR, message3).range((PsiElement)modifiersList);
                    GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(builder3, method, true, message3, modifierOrList.getTextRange()).create();
                }
            }
            if (method.isConstructor()) {
                UtilKt.checkModifierIsNotAllowed(modifiersList, "static", GroovyBundle.message("constructor.cannot.have.static.modifier", new Object[0]), holder);
            }
        }
        if (method.hasModifierProperty("native") && method.getBlock() != null) {
            message = GroovyBundle.message("native.methods.cannot.have.body", new Object[0]);
            PsiElement list = GroovyAnnotator.getModifierOrList(modifiersList, "native");
            builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(list);
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix((PsiMember)modifiersList.getParent(), "native", true, false, GrModifierFix.MODIFIER_LIST), modifiersList, message, ProblemHighlightType.ERROR, list.getTextRange());
            builder.withFix(QuickFixFactory.getInstance().createDeleteMethodBodyFix((PsiMethod)method)).create();
        }
    }

    private static void checkForAbstractAndFinalCombination(AnnotationHolder holder, GrMember member, GrModifierList modifiersList) {
        if (member.hasModifierProperty("final") && member.hasModifierProperty("abstract")) {
            String message = GroovyBundle.message("illegal.combination.of.modifiers.abstract.and.final", new Object[0]);
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)modifiersList);
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "final", false, false, GrModifierFix.MODIFIER_LIST), modifiersList, message, ProblemHighlightType.ERROR, modifiersList.getTextRange());
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "abstract", false, false, GrModifierFix.MODIFIER_LIST), modifiersList, message, ProblemHighlightType.ERROR, modifiersList.getTextRange());
            builder.create();
        }
    }

    @NotNull
    private static PsiElement getModifierOrList(@NotNull GrModifierList modifiersList, @GrModifier.GrModifierConstant String modifier) {
        PsiElement m = modifiersList.getModifier(modifier);
        return m != null ? m : modifiersList;
    }

    private static void checkOverrideAnnotation(AnnotationHolder holder, GrModifierList list, GrMethod method) {
        PsiAnnotation overrideAnnotation = list.findAnnotation("java.lang.Override");
        if (overrideAnnotation == null) {
            return;
        }
        try {
            MethodSignatureBackedByPsiMethod superMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superMethod == null) {
                holder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("method.does.not.override.super", new Object[0])).range((PsiElement)overrideAnnotation).create();
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    private static void checkTypeDefinitionModifiers(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        PsiClassType[] extendsListTypes;
        GrModifierList modifiersList = typeDefinition.getModifierList();
        if (modifiersList == null) {
            return;
        }
        GroovyAnnotator.checkAccessModifiers(holder, modifiersList, typeDefinition);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifiersList, typeDefinition);
        for (PsiClassType classType : extendsListTypes = typeDefinition.getExtendsListTypes()) {
            PsiClass psiClass = classType.resolve();
            if (psiClass == null || !psiClass.hasModifierProperty("final")) continue;
            PsiElement identifierGroovy = typeDefinition.getNameIdentifierGroovy();
            String message = GroovyBundle.message("final.class.cannot.be.extended", new Object[0]);
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(identifierGroovy);
            builder = UtilKt.registerLocalFix(builder, new GrModifierFix(typeDefinition, "final", false, false, GrModifierFix.MODIFIER_LIST_OWNER), typeDefinition, message, ProblemHighlightType.ERROR, identifierGroovy.getTextRange());
            builder.create();
        }
        if (!typeDefinition.isEnum()) {
            GroovyAnnotator.checkForAbstractAndFinalCombination(holder, typeDefinition, modifiersList);
        }
        UtilKt.checkModifierIsNotAllowed(modifiersList, "transient", GroovyBundle.message("modifier.transient.not.allowed.here", new Object[0]), holder);
        UtilKt.checkModifierIsNotAllowed(modifiersList, "volatile", GroovyBundle.message("modifier.volatile.not.allowed.here", new Object[0]), holder);
        if (typeDefinition.isInterface()) {
            UtilKt.checkModifierIsNotAllowed(modifiersList, "final", GroovyBundle.message("interface.cannot.have.modifier.final", new Object[0]), holder);
        }
    }

    private static void checkDuplicateModifiers(AnnotationHolder holder, @NotNull GrModifierList list, PsiMember member) {
        PsiElement[] modifiers = list.getModifiers();
        HashSet<String> set = new HashSet<String>(modifiers.length);
        for (PsiElement modifier : modifiers) {
            if (modifier instanceof GrAnnotation) continue;
            String name = modifier.getText();
            if (set.contains(name)) {
                String message = GroovyBundle.message("duplicate.modifier", name);
                AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)list);
                if (member != null) {
                    builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, name, false, false, GrModifierFix.MODIFIER_LIST), list, message, ProblemHighlightType.ERROR, list.getTextRange());
                }
                builder.create();
                continue;
            }
            set.add(name);
        }
    }

    private static void checkAccessModifiers(AnnotationHolder holder, @NotNull GrModifierList modifierList, PsiMember member) {
        boolean hasPrivate = modifierList.hasExplicitModifier("private");
        boolean hasPublic = modifierList.hasExplicitModifier("public");
        boolean hasProtected = modifierList.hasExplicitModifier("protected");
        if (hasPrivate && hasPublic || hasPrivate && hasProtected || hasPublic && hasProtected) {
            String message = GroovyBundle.message("illegal.combination.of.modifiers", new Object[0]);
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)modifierList);
            if (hasPrivate) {
                builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "private", false, false, GrModifierFix.MODIFIER_LIST), modifierList, message, ProblemHighlightType.ERROR, modifierList.getTextRange());
            }
            if (hasProtected) {
                builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "protected", false, false, GrModifierFix.MODIFIER_LIST), modifierList, message, ProblemHighlightType.ERROR, modifierList.getTextRange());
            }
            if (hasPublic) {
                builder = UtilKt.registerLocalFix(builder, new GrModifierFix(member, "public", false, false, GrModifierFix.MODIFIER_LIST), modifierList, message, ProblemHighlightType.ERROR, modifierList.getTextRange());
            }
            builder.create();
        } else if (member instanceof PsiClass && member.getContainingClass() == null && GroovyConfigUtils.getInstance().isVersionAtLeast((PsiElement)member, "2.0")) {
            UtilKt.checkModifierIsNotAllowed(modifierList, "private", GroovyBundle.message("top.level.class.may.not.have.private.modifier", new Object[0]), holder);
            UtilKt.checkModifierIsNotAllowed(modifierList, "protected", GroovyBundle.message("top.level.class.may.not.have.protected.modifier", new Object[0]), holder);
        }
    }

    private void checkDuplicateMethod(@NotNull GrMethod method) {
        PsiClass clazz = method.getContainingClass();
        if (clazz == null) {
            return;
        }
        GrReflectedMethod[] reflectedMethods = method.getReflectedMethods();
        if (reflectedMethods.length == 0) {
            this.doCheckDuplicateMethod(method, clazz);
        } else {
            for (GrReflectedMethod reflectedMethod : reflectedMethods) {
                this.doCheckDuplicateMethod(reflectedMethod, clazz);
            }
        }
    }

    private void doCheckDuplicateMethod(@NotNull GrMethod method, @NotNull PsiClass clazz) {
        Set<MethodSignature> duplicatedSignatures = GrClassImplUtil.getDuplicatedSignatures(clazz);
        if (duplicatedSignatures.isEmpty()) {
            return;
        }
        PsiSubstitutor substitutor2 = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)method);
        MethodSignature signature = method.getSignature(substitutor2);
        if (!duplicatedSignatures.contains(signature)) {
            return;
        }
        String signaturePresentation = GroovyPresentationUtil.getSignaturePresentation(signature);
        GrMethod original = method instanceof GrReflectedMethod ? ((GrReflectedMethod)method).getBaseMethod() : method;
        this.myHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("method.duplicate", signaturePresentation, clazz.getName())).range(GrHighlightUtil.getMethodHeaderTextRange(original)).create();
    }

    private static void checkTypeDefinition(AnnotationHolder holder, @NotNull GrTypeDefinition typeDefinition) {
        GrTypeDefinition owner;
        PsiClass superClass;
        if (typeDefinition.isAnonymous() && (superClass = ((PsiAnonymousClass)typeDefinition).getBaseClassType().resolve()) instanceof GrTypeDefinition && !GroovyConfigUtils.getInstance().isVersionAtLeast(typeDefinition, "2.5.2") && ((GrTypeDefinition)superClass).isTrait()) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("anonymous.classes.cannot.be.created.from.traits", new Object[0])).range(typeDefinition.getNameIdentifierGroovy()).create();
        }
        if (typeDefinition.isAnnotationType() && typeDefinition.getContainingClass() != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("annotation.type.cannot.be.inner", new Object[0])).range(typeDefinition.getNameIdentifierGroovy()).create();
        }
        if (!typeDefinition.hasModifierProperty("static") && (typeDefinition.getContainingClass() != null || typeDefinition instanceof GrAnonymousClassDefinition) && (owner = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)typeDefinition, GrTypeDefinition.class)) instanceof GrTraitTypeDefinition) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("non.static.classes.not.allowed", new Object[0])).range(typeDefinition.getNameIdentifierGroovy()).create();
        }
        GroovyAnnotator.checkTypeDefinitionModifiers(holder, typeDefinition);
        GroovyAnnotator.checkDuplicateClass(typeDefinition, holder);
        GroovyAnnotator.checkCyclicInheritance(holder, typeDefinition);
    }

    private static void checkCyclicInheritance(AnnotationHolder holder, @NotNull GrTypeDefinition typeDefinition) {
        PsiClass psiClass = InheritanceUtil.getCircularClass((PsiClass)typeDefinition);
        if (psiClass != null) {
            String qname = psiClass.getQualifiedName();
            assert (qname != null);
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cyclic.inheritance.involving.0", qname)).range(GrHighlightUtil.getClassHeaderTextRange(typeDefinition)).create();
        }
    }

    private static void checkForWildCards(AnnotationHolder holder, @Nullable GrReferenceList clause) {
        GrCodeReferenceElement[] elements;
        if (clause == null) {
            return;
        }
        for (GrCodeReferenceElement element : elements = clause.getReferenceElementsGroovy()) {
            GrTypeArgumentList list = element.getTypeArgumentList();
            if (list == null) continue;
            for (GrTypeElement type2 : list.getTypeArgumentElements()) {
                if (!(type2 instanceof GrWildcardTypeArgument)) continue;
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("wildcards.are.not.allowed.in.extends.list", new Object[0])).range((PsiElement)type2).create();
            }
        }
    }

    private static void checkDuplicateClass(GrTypeDefinition typeDefinition, AnnotationHolder holder) {
        GlobalSearchScope scope;
        JavaPsiFacade facade;
        PsiClass[] classes2;
        String qName;
        String containingClassName;
        PsiClass containingClass = typeDefinition.getContainingClass();
        String name = typeDefinition.getName();
        if (containingClass != null && (containingClassName = containingClass.getName()) != null && containingClassName.equals(name)) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("duplicate.inner.class", name)).range(typeDefinition.getNameIdentifierGroovy()).create();
        }
        if ((qName = typeDefinition.getQualifiedName()) != null && (classes2 = (facade = JavaPsiFacade.getInstance((Project)typeDefinition.getProject())).findClasses(qName, scope = GroovyAnnotator.inferClassScopeForSearchingDuplicates(typeDefinition))).length > 1) {
            String packageName = GroovyAnnotator.getPackageName(typeDefinition);
            if (!GroovyAnnotator.isScriptGeneratedClass(classes2)) {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("duplicate.class", name, packageName)).range(typeDefinition.getNameIdentifierGroovy()).create();
            } else {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("script.generated.with.same.name", qName)).range(typeDefinition.getNameIdentifierGroovy()).create();
            }
        }
    }

    private static GlobalSearchScope inferClassScopeForSearchingDuplicates(GrTypeDefinition typeDefinition) {
        Module module;
        GlobalSearchScope defaultScope = typeDefinition.getResolveScope();
        PsiFile file = typeDefinition.getContainingFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null) {
            return defaultScope.intersectWith(module.getModuleScope());
        }
        return defaultScope;
    }

    @NlsSafe
    private static String getPackageName(GrTypeDefinition typeDefinition) {
        String name;
        PsiFile file = typeDefinition.getContainingFile();
        String packageName = "<default package>";
        if (file instanceof GroovyFile && !(name = ((GroovyFile)file).getPackageName()).isEmpty()) {
            packageName = name;
        }
        return packageName;
    }

    private static boolean isScriptGeneratedClass(PsiClass[] allClasses) {
        return allClasses.length == 2 && (allClasses[0] instanceof GroovyScriptClass || allClasses[1] instanceof GroovyScriptClass);
    }
}

