/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighterFactory;
import org.jetbrains.plugins.groovy.annotator.InaccessibleElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GrReferenceHighlighter
extends TextEditorHighlightingPass {
    private final GroovyFileBase myFile;
    private List<HighlightInfo> myInfos = null;

    public GrReferenceHighlighter(@NotNull GroovyFileBase file, @NotNull Document document) {
        super(file.getProject(), document);
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (!GrReferenceHighlighterFactory.shouldHighlight(this.myFile)) {
            return;
        }
        this.myInfos = new ArrayList<HighlightInfo>();
        this.myFile.accept(new InaccessibleElementVisitor(this.myFile, this.myProject, (e, info) -> this.myInfos.add(info)));
    }

    public void doApplyInformationToEditor() {
        if (this.myInfos == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), this.myInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }
}

