/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrAnnotatorImpl;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator;
import org.jetbrains.plugins.groovy.annotator.ImplKt;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.groovy.psi"})
public final class GrAnnotatorImpl
implements Annotator {
    /*
     * WARNING - void declaration
     */
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (FileIndexFacade.getInstance((Project)file.getProject()).isInLibrarySource(file.getVirtualFile())) {
            return;
        }
        if (element instanceof GroovyPsiElement && !PsiUtilKt.isFake((GroovyPsiElement)element)) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator(holder));
            if (CompileStaticUtil.isCompileStatic(element)) {
                ((GroovyPsiElement)element).accept(new GroovyStaticTypeCheckVisitor(holder));
            }
        } else if (element instanceof PsiComment) {
            String text = element.getText();
            if (StringsKt.startsWith$default((String)text, (String)"/*", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)text, (String)"*/", (boolean)false, (int)2, null)) {
                TextRange range = element.getTextRange();
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("doc.end.expected", new Object[0])).range(TextRange.create((int)(range.getEndOffset() - 1), (int)range.getEndOffset())).create();
            }
        } else {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GrMethod && Intrinsics.areEqual((Object)element, (Object)((GrMethod)parent2).getNameIdentifierGroovy())) {
                Collection $this$mapTo$iv;
                Sequence sequence = Regex.findAll$default((Regex)ImplKt.getIllegalJvmNameSymbols(), (CharSequence)((GrMethod)parent2).getName(), (int)0, (int)2, null);
                Collection destination$iv = new HashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    MatchResult matchResult = (MatchResult)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    String string = it.getValue();
                    collection.add(string);
                }
                HashSet illegalCharacters = (HashSet)destination$iv;
                $this$mapTo$iv = illegalCharacters;
                if (!$this$mapTo$iv.isEmpty() && !PsiUtilKt.isFake((GroovyPsiElement)parent2)) {
                    String chars2 = CollectionsKt.joinToString$default((Iterable)illegalCharacters, null, null, null, (int)0, null, (Function1)annotate.chars.1.INSTANCE, (int)31, null);
                    holder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("illegal.method.name", chars2)).create();
                }
                if (((GrMethod)parent2).getReturnTypeElementGroovy() == null) {
                    GroovyAnnotator.checkMethodReturnType((PsiMethod)parent2, element, holder);
                }
            } else if (parent2 instanceof GrField && Intrinsics.areEqual((Object)element, (Object)((GrField)parent2).getNameIdentifierGroovy())) {
                GrAccessorMethod[] getters;
                for (GrAccessorMethod getter : getters = ((GrField)parent2).getGetters()) {
                    GroovyAnnotator.checkMethodReturnType(getter, ((GrField)parent2).getNameIdentifierGroovy(), holder);
                }
                GrAccessorMethod setter = ((GrField)parent2).getSetter();
                if (setter != null) {
                    GroovyAnnotator.checkMethodReturnType(setter, ((GrField)parent2).getNameIdentifierGroovy(), holder);
                }
            }
        }
    }
}

