/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyEnabledFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public final class GroovyFileType
extends LanguageFileType {
    @NotNull
    public static final GroovyFileType GROOVY_FILE_TYPE = new GroovyFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "groovy";

    private GroovyFileType() {
        super((Language)GroovyLanguage.INSTANCE);
    }

    @NotNull
    @NonNls
    public String getName() {
        return "Groovy";
    }

    @NotNull
    public String getDescription() {
        return GroovyBundle.message("filetype.groovy.description", new Object[0]);
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    @NotNull
    public static @NotNull FileType @NotNull [] getGroovyEnabledFileTypes() {
        LinkedHashSet result2 = new LinkedHashSet();
        result2.addAll(ContainerUtil.filter((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), GroovyFileType::isGroovyEnabledFileType));
        return result2.toArray(FileType.EMPTY_ARRAY);
    }

    private static boolean isGroovyEnabledFileType(FileType ft) {
        return ft instanceof GroovyEnabledFileType || ft instanceof LanguageFileType && ((LanguageFileType)ft).getLanguage() == GroovyLanguage.INSTANCE;
    }
}

