/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLightProjectDescriptor
extends LightProjectDescriptor {
    @Nullable
    private Supplier<? extends Sdk> customSdk;
    private final List<RequiredLibrary> mavenLibraries = new ArrayList<RequiredLibrary>();

    public DefaultLightProjectDescriptor() {
    }

    public DefaultLightProjectDescriptor(@NotNull Supplier<? extends Sdk> customSdk) {
        this.customSdk = customSdk;
    }

    public DefaultLightProjectDescriptor(@NotNull Supplier<? extends Sdk> customSdk, @NotNull List<String> mavenLibraries) {
        this.customSdk = customSdk;
        for (String library : mavenLibraries) {
            this.withRepositoryLibrary(library);
        }
    }

    @NotNull
    public String getModuleTypeId() {
        return "JAVA_MODULE";
    }

    public Sdk getSdk() {
        return this.customSdk == null ? IdeaTestUtil.getMockJdk17() : this.customSdk.get();
    }

    public void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class);
        if (extension != null) {
            extension.setLanguageLevel(LanguageLevel.HIGHEST);
            for (RequiredLibrary library : this.mavenLibraries) {
                MavenDependencyUtil.addFromMaven(model, library.mavenCoordinates, library.includeTransitive);
            }
        }
    }

    public DefaultLightProjectDescriptor withRepositoryLibrary(@NotNull String library) {
        return this.withRepositoryLibrary(library, true);
    }

    public DefaultLightProjectDescriptor withRepositoryLibrary(@NotNull String library, boolean includeTransitive) {
        this.mavenLibraries.add(new RequiredLibrary(library, includeTransitive));
        return this;
    }

    private static class RequiredLibrary {
        public final String mavenCoordinates;
        public final boolean includeTransitive;

        private RequiredLibrary(String coordinates, boolean transitive) {
            this.mavenCoordinates = coordinates;
            this.includeTransitive = transitive;
        }
    }
}

