/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.ProjectViewTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestSourceBasedTestCase
extends JavaProjectTestCase {
    private Path myTempDirectory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VirtualFile tempDir = this.getTempDir().createVirtualDir();
        this.myTempDirectory = tempDir.toNioPath();
        String testPath = this.getTestPath();
        if (testPath != null) {
            File testRoot = new File(this.getTestDataPath(), testPath);
            TestSourceBasedTestCase.assertTrue((String)testRoot.getAbsolutePath(), (boolean)testRoot.isDirectory());
            File currentTestRoot = new File(testRoot, this.getTestDirectoryName());
            TestSourceBasedTestCase.assertTrue((String)currentTestRoot.getAbsolutePath(), (boolean)currentTestRoot.isDirectory());
            FileUtil.copyDir((File)currentTestRoot, (File)this.myTempDirectory.resolve(this.getTestDirectoryName()).toFile());
            tempDir.refresh(false, true);
            ApplicationManager.getApplication().runWriteAction(() -> {
                VirtualFile contentRoot = tempDir.findChild(this.getTestDirectoryName());
                PsiTestUtil.addContentRoot((Module)this.myModule, (VirtualFile)contentRoot);
                VirtualFile src = contentRoot.findChild("src");
                if (src != null) {
                    PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)src);
                }
            });
        }
        ProjectViewTestUtil.setupImpl((Project)this.getProject(), (boolean)true);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath(((Object)((Object)this)).getClass());
    }

    @Nullable
    protected abstract String getTestPath();

    protected final VirtualFile getContentRoot() {
        return LocalFileSystem.getInstance().findFileByNioFile(this.myTempDirectory.resolve(this.getTestDirectoryName()));
    }

    @NotNull
    protected String getTestDirectoryName() {
        return this.getTestName(true);
    }

    protected final PsiDirectory getPackageDirectory(@NotNull String packageRelativePath) {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src/" + packageRelativePath));
    }

    protected final PsiDirectory getSrcDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src"));
    }

    protected final PsiDirectory getContentDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot());
    }
}

