/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TestLogger;
import com.intellij.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.LogManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class TestLoggerFactory
implements Logger.Factory {
    private static final String SPLIT_TEST_LOGS_KEY = "idea.split.test.logs";
    private static final String SPLIT_LOGS_SUBDIR = "splitTestLogs";
    private static boolean SPLIT_TEST_LOGS = SystemProperties.getBooleanProperty((String)"idea.split.test.logs", (boolean)false);
    private static final String LOG_DIR = "testlog";
    private static final long LOG_SIZE_LIMIT = 0x6400000L;
    private static final long LOG_SEEK_WINDOW = 102400L;
    private boolean myInitialized;
    private static final char FAILED_TEST_DEBUG_OUTPUT_MARKER = '\u2003';
    private static final StringBuilder BUFFER = new StringBuilder();
    private static final int MAX_BUFFER_LENGTH = 10000000;

    private TestLoggerFactory() {
    }

    @NotNull
    public synchronized Logger getLoggerInstance(@NotNull String category) {
        if (!this.myInitialized && TestLoggerFactory.reconfigure()) {
            this.myInitialized = true;
        }
        return new TestLogger(category);
    }

    static boolean shouldSplitTestLogs() {
        return SPLIT_TEST_LOGS;
    }

    public static boolean reconfigure() {
        try {
            Path logProperties;
            String customConfigPath = System.getProperty("idea.log.config.properties.file");
            Path path = logProperties = customConfigPath != null ? Paths.get(customConfigPath, new String[0]) : Paths.get(PathManager.getHomePath(), "test-log.properties");
            if (Files.exists(logProperties, new LinkOption[0])) {
                try (InputStream in = Files.newInputStream(logProperties, new OpenOption[0]);){
                    BufferedInputStream bin = new BufferedInputStream(in);
                    LogManager.getLogManager().readConfiguration(bin);
                }
            }
            Path logDir = TestLoggerFactory.getTestLogDir();
            Files.createDirectories(logDir, new FileAttribute[0]);
            Path logFile = logDir.resolve("idea.log");
            JulLogger.clearHandlers();
            JulLogger.configureLogFileAndConsole((Path)logFile, (boolean)false, (boolean)false, (boolean)true, null);
            if (Files.exists(logFile, new LinkOption[0]) && Files.size(logFile) >= 0x6400000L) {
                Files.writeString(logFile, (CharSequence)"", new OpenOption[0]);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public static Path getTestLogDir() {
        String property = System.getProperty("idea.log.path");
        return property == null ? Path.of(PathManager.getSystemPath(), LOG_DIR) : Path.of(property, new String[0]);
    }

    public static void dumpLogToStdout(@NotNull String testStartMarker) {
        Path logFile = TestLoggerFactory.getTestLogDir().resolve("idea.log");
        if (Files.exists(logFile, new LinkOption[0])) {
            try {
                String logText;
                long length = Files.size(logFile);
                if (length > 102400L) {
                    try (RandomAccessFile file = new RandomAccessFile(logFile.toFile(), "r");){
                        file.seek(length - 102400L);
                        byte[] bytes = new byte[102400];
                        int read = file.read(bytes);
                        logText = new String(bytes, 0, read, StandardCharsets.UTF_8);
                    }
                } else {
                    logText = Files.readString(logFile);
                }
                System.out.println("\n\nIdea Log:");
                Pattern logStart = Pattern.compile("[\\d\\-, :\\[\\]]+(DEBUG|INFO|ERROR) - ");
                for (String line : StringUtil.splitByLines((String)logText.substring(Math.max(0, logText.lastIndexOf(testStartMarker))))) {
                    Matcher matcher = logStart.matcher(line);
                    int lineStart = matcher.lookingAt() ? matcher.end() : 0;
                    System.out.println(line.substring(lineStart));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, String ... categories) {
        for (String category : categories) {
            Logger logger = Logger.getInstance((String)category);
            if (logger.isDebugEnabled()) continue;
            logger.setLevel(LogLevel.DEBUG);
            Disposer.register((Disposable)parentDisposable, () -> logger.setLevel(LogLevel.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(@NotNull String level, @NotNull String category, @Nullable String message, @Nullable Throwable t) {
        StringWriter writer = new StringWriter(t == null ? 256 : 4096);
        String source = category.substring(Math.max(category.length() - 30, 0));
        writer.write(String.format("%1$tH:%1$tM:%1$tS,%1$tL %2$-5s %3$30s - ", System.currentTimeMillis(), level, source));
        writer.write(message != null ? message : "");
        writer.write(System.lineSeparator());
        if (t != null) {
            t.printStackTrace(new PrintWriter(writer));
            writer.write(System.lineSeparator());
        }
        StringBuilder stringBuilder = BUFFER;
        synchronized (stringBuilder) {
            BUFFER.append(writer.getBuffer());
            if (BUFFER.length() > 10000000) {
                BUFFER.delete(0, BUFFER.length() - 10000000 + 2500000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTestStarted() {
        StringBuilder stringBuilder = BUFFER;
        synchronized (stringBuilder) {
            BUFFER.setLength(0);
        }
    }

    @NotNull
    private static String saveSplitLog(@NotNull String testName2, @NotNull String buffer) {
        Path logsDir = TestLoggerFactory.getTestLogDir().resolve(SPLIT_LOGS_SUBDIR);
        try {
            Files.createDirectories(logsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            buffer = (String)buffer + "\nUnable to create dir for split logs, disabling splitting: " + logsDir;
            SPLIT_TEST_LOGS = false;
            return buffer;
        }
        String testFileName = FileUtil.sanitizeFileName((String)testName2);
        File logFile = FileUtil.findSequentNonexistentFile((File)logsDir.toFile(), (String)testFileName, (String)"log");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, StandardCharsets.UTF_8));){
            writer.write((String)buffer);
        }
        catch (IOException e) {
            buffer = (String)buffer + "\nError writing split log, disabling splitting: " + logFile + "\n" + e;
            SPLIT_TEST_LOGS = false;
            return buffer;
        }
        return "Log saved to: " + logFile.getName() + " (" + logFile + ")";
    }

    @Deprecated
    public static void onTestFinished(boolean success) {
        TestLoggerFactory.onTestFinished(success, "unnamed_test");
    }

    public static void onTestFinished(boolean success, @NotNull Description description) {
        TestLoggerFactory.onTestFinished(success, description.getDisplayName());
    }

    public static void logTestFailure(@NotNull Throwable t) {
        if (TestLoggerFactory.shouldSplitTestLogs()) {
            TestLoggerFactory.log(LogLevel.ERROR.toString(), "Test framework", "Test failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTestFinished(boolean success, @NotNull String testName2) {
        String buffer;
        StringBuilder stringBuilder = BUFFER;
        synchronized (stringBuilder) {
            buffer = BUFFER.length() != 0 && !success ? BUFFER.toString() : null;
            BUFFER.setLength(0);
        }
        if (buffer != null) {
            if (TestLoggerFactory.shouldSplitTestLogs()) {
                buffer = TestLoggerFactory.saveSplitLog(testName2, buffer);
            }
            if (System.getenv("TEAMCITY_VERSION") != null) {
                System.out.flush();
                System.out.println("##teamcity[blockOpened name='DEBUG log']");
                System.out.flush();
                System.out.println(buffer);
                System.out.flush();
                System.out.println("##teamcity[blockClosed name='DEBUG log']");
                System.out.flush();
            } else {
                List lines = LineTokenizer.tokenizeIntoList((CharSequence)buffer, (boolean)false, (boolean)false);
                if (!((String)lines.get(0)).startsWith("\n")) {
                    lines.set(0, "\n" + (String)lines.get(0));
                }
                System.err.println(String.join((CharSequence)"\u2003\n", lines));
            }
        }
    }

    @NotNull
    public static TestRule createTestWatcher() {
        return new TestWatcher(){

            protected void succeeded(Description description) {
                TestLoggerFactory.onTestFinished(true, description);
            }

            protected void failed(Throwable e, Description description) {
                TestLoggerFactory.logTestFailure(e);
                TestLoggerFactory.onTestFinished(false, description);
            }

            protected void skipped(AssumptionViolatedException e, Description description) {
                TestLoggerFactory.onTestFinished(true, description);
            }

            protected void starting(@NotNull Description d) {
                TestLoggerFactory.onTestStarted();
            }
        };
    }
}

