/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestLogger
extends JulLogger {
    TestLogger(@NotNull String category) {
        super(Logger.getLogger(category));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (LoggedErrorProcessor.getInstance().processError(this.myLogger.getName(), (String)message, TestLogger.ensureNotControlFlow((Throwable)t), details)) {
            if (t instanceof TestLoggerAssertionError && ((String)message).equals(t.getMessage()) && details.length == 0) {
                throw (TestLoggerAssertionError)((Object)t);
            }
            if (TestLoggerFactory.shouldSplitTestLogs()) {
                TestLoggerFactory.log(Level.SEVERE.toString(), this.myLogger.getName(), (String)message, t);
                for (String detail : details) {
                    TestLoggerFactory.log(Level.SEVERE.toString(), this.myLogger.getName(), detail, null);
                }
            }
            message = (String)message + DefaultLogger.attachmentsToString((Throwable)t);
            this.myLogger.log(Level.INFO, (String)message, t);
            DefaultLogger.dumpExceptionsToStderr((String)message, (Throwable)t, (String[])details);
            throw new TestLoggerAssertionError((String)message, t);
        }
    }

    public void warn(String message, @Nullable Throwable t) {
        if (LoggedErrorProcessor.getInstance().processWarn(this.myLogger.getName(), message, TestLogger.ensureNotControlFlow((Throwable)t))) {
            if (TestLoggerFactory.shouldSplitTestLogs()) {
                TestLoggerFactory.log(Level.WARNING.toString(), this.myLogger.getName(), message, t);
            }
            this.myLogger.log(Level.WARNING, message, t);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, @Nullable Throwable t) {
        super.info(message, t);
        TestLoggerFactory.log(Level.INFO.toString(), this.myLogger.getName(), message, t);
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(@Nullable Throwable t) {
        this.debug(null, t);
    }

    public void debug(String message, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(message, t);
            TestLoggerFactory.log(Level.FINE.toString(), this.myLogger.getName(), message, t);
        }
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            super.trace(message);
            TestLoggerFactory.log(Level.FINER.toString(), this.myLogger.getName(), message, null);
        }
    }

    public void trace(@Nullable Throwable t) {
        if (this.isTraceEnabled()) {
            super.trace(t);
            TestLoggerFactory.log(Level.FINER.toString(), this.myLogger.getName(), null, t);
        }
    }

    public boolean isDebugEnabled() {
        return !Accessor.isInStressTest() || super.isDebugEnabled();
    }

    private static class Accessor {
        @Nullable
        private static final MethodHandle isInStressTest = Accessor.getMethodHandle();

        private Accessor() {
        }

        private static MethodHandle getMethodHandle() {
            try {
                Class<?> clazz = Class.forName("com.intellij.openapi.application.ex.ApplicationManagerEx");
                return MethodHandles.publicLookup().findStatic(clazz, "isInStressTest", MethodType.methodType(Boolean.TYPE));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return null;
            }
        }

        private static boolean isInStressTest() {
            try {
                return isInStressTest != null && isInStressTest.invokeExact();
            }
            catch (Throwable ignored) {
                return false;
            }
        }
    }

    static final class TestLoggerAssertionError
    extends AssertionError {
        private TestLoggerAssertionError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

