/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public class LoggedErrorProcessor {
    private static LoggedErrorProcessor ourInstance = new LoggedErrorProcessor();

    @NotNull
    static LoggedErrorProcessor getInstance() {
        return ourInstance;
    }

    private static void setNewInstance(@NotNull LoggedErrorProcessor newInstance) {
        ourInstance = newInstance;
    }

    public static <T extends Throwable> void executeWith(@NotNull LoggedErrorProcessor newInstance, @NotNull ThrowableRunnable<T> runnable) throws T {
        LoggedErrorProcessor oldInstance = LoggedErrorProcessor.getInstance();
        LoggedErrorProcessor.setNewInstance(newInstance);
        try {
            runnable.run();
        }
        finally {
            LoggedErrorProcessor.setNewInstance(oldInstance);
        }
    }

    public boolean processWarn(@NotNull String category, String message, Throwable t) {
        return true;
    }

    public boolean processError(@NotNull String category, String message, Throwable t, String @NotNull [] details) {
        return true;
    }
}

