/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.JavaPsiTestCase;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.VfsTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaResolveTestCase
extends JavaPsiTestCase {
    protected static final String MARKER = "<ref>";
    private Document myDocument;

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myDocument != null) {
                FileDocumentManager.getInstance().reloadFromDisk(this.myDocument);
                this.myDocument = null;
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected PsiReference configureByFile(@NotNull String filePath) throws Exception {
        return this.configureByFile(filePath, null);
    }

    protected PsiReference configureByFile(@TestDataFile @NotNull String filePath, @Nullable VirtualFile parentDir) throws Exception {
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath((String)(this.getTestDataPath() + filePath));
        JavaResolveTestCase.assertNotNull((String)("file " + filePath + " not found"), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)vFile));
        return this.configureByFileText(fileText, vFile.getName(), parentDir);
    }

    protected PsiReference configureByFileText(String fileText, String fileName) throws Exception {
        return this.configureByFileText(fileText, fileName, null);
    }

    protected PsiReference configureByFileText(String fileText, String fileName, @Nullable VirtualFile parentDir) throws Exception {
        int offset = ((String)fileText).indexOf(MARKER);
        JavaResolveTestCase.assertTrue((String)String.format("Expected to find %s marker in file but was none", MARKER), (offset >= 0 ? 1 : 0) != 0);
        fileText = ((String)fileText).substring(0, offset) + ((String)fileText).substring(offset + MARKER.length());
        if (parentDir == null) {
            this.myFile = this.createFile(this.myModule, fileName, (String)fileText);
        } else {
            VirtualFile existing = parentDir.findChild(fileName);
            if (existing != null) {
                this.myDocument = FileDocumentManager.getInstance().getDocument(existing);
                JavaResolveTestCase.assertNotNull((Object)this.myDocument);
                Object finalFileText = fileText;
                ApplicationManager.getApplication().runWriteAction(() -> this.lambda$configureByFileText$0((String)finalFileText));
                this.myFile = PsiManager.getInstance((Project)this.getProject()).findFile(existing);
                JavaResolveTestCase.assertNotNull((Object)this.myFile);
                JavaResolveTestCase.assertEquals((String)fileText, (String)this.myFile.getText());
            } else {
                this.myFile = this.createFile(this.myModule, parentDir, fileName, (String)fileText);
            }
        }
        PsiReference ref = this.myFile.findReferenceAt(offset);
        JavaResolveTestCase.assertNotNull((Object)ref);
        return ref;
    }

    @Override
    @NotNull
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/psi/resolve/";
    }

    private /* synthetic */ void lambda$configureByFileText$0(String finalFileText) {
        this.myDocument.setText((CharSequence)finalFileText);
    }
}

