/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import com.sun.tools.javac.Main;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;
import org.junit.Assume;

@TestOnly
public final class IdeaTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Runnable r) {
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelUtil.getCustomLanguageLevel((Module)module);
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @Nullable LanguageLevel level) {
        ModuleRootModificationUtil.updateModel((Module)module, model -> ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level));
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Disposable parentDisposable) {
        LanguageLevel prev = LanguageLevelUtil.getCustomLanguageLevel((Module)module);
        IdeaTestUtil.setModuleLanguageLevel(module, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module, prev));
    }

    @NotNull
    public static Sdk getMockJdk(@NotNull JavaVersion version) {
        int mockJdk = version.feature >= 11 ? 11 : (version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4)));
        String path = IdeaTestUtil.getPathForJdkNamed(MOCK_JDK_DIR_NAME_PREFIX + (mockJdk < 11 ? "1." : "") + mockJdk).getPath();
        return IdeaTestUtil.createMockJdk("java " + version, path);
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path) {
        return IdeaTestUtil.createMockJdk(name, path, false);
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path, boolean isJre) {
        JavaSdk javaSdk = JavaSdk.getInstance();
        if (javaSdk == null) {
            throw new AssertionError((Object)"The test uses classes from Java plugin but Java plugin wasn't loaded; make sure that Java plugin classes are included into classpath and that the plugin isn't disabled by using 'idea.load.plugins', 'idea.load.plugins.id', 'idea.load.plugins.category' system properties");
        }
        final MultiMap roots = MultiMap.create();
        SdkModificator sdkModificator = new SdkModificator(){

            @NotNull
            public String getName() {
                throw new UnsupportedOperationException();
            }

            public void setName(@NotNull String name1) {
                throw new UnsupportedOperationException();
            }

            public String getHomePath() {
                throw new UnsupportedOperationException();
            }

            public void setHomePath(String path1) {
                throw new UnsupportedOperationException();
            }

            public String getVersionString() {
                throw new UnsupportedOperationException();
            }

            public void setVersionString(String versionString) {
                throw new UnsupportedOperationException();
            }

            public SdkAdditionalData getSdkAdditionalData() {
                throw new UnsupportedOperationException();
            }

            public void setSdkAdditionalData(SdkAdditionalData data) {
                throw new UnsupportedOperationException();
            }

            public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
                return roots.get((Object)rootType).toArray(VirtualFile.EMPTY_ARRAY);
            }

            public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeRoots(@NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeAllRoots() {
                throw new UnsupportedOperationException();
            }

            public void commitChanges() {
                throw new UnsupportedOperationException();
            }

            public boolean isWritable() {
                throw new UnsupportedOperationException();
            }

            public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                roots.putValue((Object)rootType, (Object)root);
            }
        };
        Path jdkHomeFile = Path.of(path, new String[0]);
        JavaSdkImpl.addClasses((Path)jdkHomeFile, (SdkModificator)sdkModificator, (boolean)isJre);
        JavaSdkImpl.addSources((Path)jdkHomeFile, (SdkModificator)sdkModificator);
        JavaSdkImpl.attachJdkAnnotations((SdkModificator)sdkModificator);
        return new MockSdk(name, PathUtil.toSystemIndependentName((String)path), name, roots, () -> JavaSdk.getInstance());
    }

    @NotNull
    public static Sdk getMockJdk14() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
    }

    @NotNull
    public static Sdk getMockJdk16() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)6));
    }

    @NotNull
    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
    }

    @NotNull
    public static Sdk getMockJdk17(@NotNull String name) {
        return IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
    }

    @NotNull
    public static Sdk getMockJdk18() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
    }

    @NotNull
    public static Sdk getMockJdk9() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
    }

    @NotNull
    public static Sdk getMockJdk11() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)11));
    }

    @NotNull
    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    @NotNull
    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    @NotNull
    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    @NotNull
    public static File getMockJdk9Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.9");
    }

    public static String getMockJdkVersion(@NotNull String path) {
        String name = PathUtil.getFileName((String)path);
        return name.startsWith(MOCK_JDK_DIR_NAME_PREFIX) ? "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX) : null;
    }

    @NotNull
    private static File getPathForJdkNamed(@NotNull String name) {
        return new File(PlatformTestUtil.getCommunityPath(), "java/" + name);
    }

    public static void addWebJarsToModule(@NotNull Module module) {
        ModuleRootModificationUtil.updateModel((Module)module, IdeaTestUtil::addWebJarsToModule);
    }

    public static void addWebJarsToModule(@NotNull ModifiableRootModel model) {
        MavenDependencyUtil.addFromMaven(model, "javax.servlet.jsp:javax.servlet.jsp-api:2.3.3");
        MavenDependencyUtil.addFromMaven(model, "javax.servlet:javax.servlet-api:3.1.0");
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        ((SdkModificator)sdk).setVersionString(testVersion.getDescription());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> ((SdkModificator)sdk).setVersionString(oldVersionString));
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            return path;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        return null;
    }

    @NotNull
    public static File findSourceFile(@NotNull String basePath) {
        File testFile = new File(basePath + ".java");
        if (!testFile.exists()) {
            testFile = new File(basePath + ".groovy");
        }
        if (!testFile.exists()) {
            throw new IllegalArgumentException("No test source for " + basePath);
        }
        return testFile;
    }

    public static void compileFile(@NotNull File source, @NotNull File out, String ... options) {
        Assert.assertTrue((String)("source does not exist: " + source.getPath()), (boolean)source.isFile());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(out.getAbsolutePath());
        ContainerUtil.addAll(args, (Object[])options);
        args.add(source.getAbsolutePath());
        if (source.getName().endsWith(".groovy")) {
            try {
                FileSystemCompiler.commandLineCompile((String[])ArrayUtilRt.toStringArray(args));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            int result = Main.compile(ArrayUtilRt.toStringArray(args));
            if (result != 0) {
                throw new IllegalStateException("javac failed with exit code " + result);
            }
        }
    }
}

