/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.OutputChecker;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.CompilerTester;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutionTestCase
extends JavaProjectTestCase {
    private OutputChecker myChecker;
    private int myTimeout;
    private static Path ourOutputRoot;
    private Path myModuleOutputDir;
    protected static final String SOURCES_DIRECTORY_NAME = "src";

    public ExecutionTestCase() {
        this.setTimeout(300000);
    }

    public final void setTimeout(int timeout) {
        this.myTimeout = timeout;
    }

    protected abstract OutputChecker initOutputChecker();

    protected abstract String getTestAppPath();

    @Override
    protected void setUp() throws Exception {
        this.setupTempDir();
        if (ourOutputRoot == null) {
            ourOutputRoot = this.getTempDir().newPath();
        }
        this.myChecker = this.initOutputChecker();
        EdtTestUtil.runInEdtAndWait(() -> super.setUp());
        this.myModuleOutputDir = this.getModuleOutputDir();
        if (!Files.exists(this.myModuleOutputDir, new LinkOption[0])) {
            Files.createDirectories(this.myModuleOutputDir, new FileAttribute[0]);
            if (FileUtil.isAncestor((File)ourOutputRoot.toFile(), (File)this.myModuleOutputDir.toFile(), (boolean)false)) {
                VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(ourOutputRoot);
                ExecutionTestCase.assertNotNull((String)ourOutputRoot.toString(), (Object)vDir);
            }
            this.compileProject();
        }
    }

    protected void compileProject() throws Exception {
        CompilerTester compilerTester = new CompilerTester(this.myProject, Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()), this.getTestRootDisposable(), this.overrideCompileJdkAndOutput());
        List<CompilerMessage> messages = compilerTester.rebuild();
        for (CompilerMessage message : messages) {
            if (message.getCategory() != CompilerMessageCategory.ERROR) continue;
            FileUtil.delete((Path)this.myModuleOutputDir);
            ExecutionTestCase.fail((String)("Compilation failed: " + message + " " + message.getVirtualFile()));
        }
    }

    @NotNull
    protected Path getModuleOutputDir() {
        return ourOutputRoot.resolve(PathUtil.getFileName((String)this.getTestAppPath()));
    }

    protected boolean overrideCompileJdkAndOutput() {
        return true;
    }

    protected void setUpModule() {
        super.setUpModule();
        ApplicationManager.getApplication().runWriteAction(() -> {
            String modulePath = this.getTestAppPath();
            String srcPath = modulePath + File.separator + SOURCES_DIRECTORY_NAME;
            VirtualFile moduleDir = LocalFileSystem.getInstance().findFileByPath(modulePath.replace(File.separatorChar, '/'));
            VirtualFile srcDir = LocalFileSystem.getInstance().findFileByPath(srcPath.replace(File.separatorChar, '/'));
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
            PsiTestUtil.removeAllRoots((Module)this.myModule, (Sdk)rootManager.getSdk());
            PsiTestUtil.addContentRoot((Module)this.myModule, (VirtualFile)moduleDir);
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)srcDir);
            IdeaTestUtil.setModuleLanguageLevel(this.myModule, LanguageLevel.JDK_1_8);
            Path outputDir = this.getModuleOutputDir();
            PsiTestUtil.setCompilerOutputPath((Module)this.myModule, (String)VfsUtilCore.pathToUrl((String)outputDir.toString()), (boolean)false);
        });
    }

    @Override
    protected Sdk getTestProjectJdk() {
        return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
    }

    public void println(@NonNls String s, Key outputType) {
        this.myChecker.println(s, outputType);
    }

    public void print(String s, Key outputType) {
        this.myChecker.print(s, outputType);
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        runnable.run();
    }

    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        this.myChecker.init(this.getTestName(true));
        super.runTestRunnable(testRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        this.myChecker = null;
        EdtTestUtil.runInEdtAndWait(() -> super.tearDown());
        ExecutionTestCase executionTestCase = this;
        synchronized (executionTestCase) {
            ((Object)((Object)this)).wait(300L);
        }
    }

    protected JavaParameters createJavaParameters(String mainClass) {
        JavaParameters parameters = new JavaParameters();
        parameters.getClassPath().add(this.getAppOutputPath());
        parameters.setMainClass(mainClass);
        parameters.setJdk(JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        parameters.setWorkingDirectory(this.getTestAppPath());
        return parameters;
    }

    protected OutputChecker getChecker() {
        return this.myChecker;
    }

    protected String getAppDataPath() {
        return this.getTestAppPath() + File.separator + "data";
    }

    protected String getAppOptionsPath() {
        return this.getTestAppPath() + File.separator + "config" + File.separator + "options";
    }

    protected String getAppOutputPath() {
        return this.getModuleOutputDir().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitProcess(@NotNull ProcessHandler processHandler) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.getTestRootDisposable());
        boolean[] isRunning = new boolean[]{true};
        alarm.addRequest(() -> {
            boolean[] blArray = isRunning;
            synchronized (isRunning) {
                boolean b = isRunning[0];
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (b) {
                    processHandler.destroyProcess();
                    LOG.error("process was running over " + this.myTimeout / 1000 + " seconds. Interrupted. ");
                }
                return;
            }
        }, this.myTimeout);
        processHandler.waitFor();
        boolean[] blArray = isRunning;
        synchronized (isRunning) {
            isRunning[0] = false;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Disposer.dispose((Disposable)alarm);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Runnable r) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.getTestRootDisposable());
        Thread thread = Thread.currentThread();
        boolean[] isRunning = new boolean[]{true};
        alarm.addRequest(() -> {
            boolean[] blArray = isRunning;
            synchronized (isRunning) {
                boolean b = isRunning[0];
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (b) {
                    thread.interrupt();
                    LOG.error("test was running over " + this.myTimeout / 1000 + " seconds. Interrupted. ");
                }
                return;
            }
        }, this.myTimeout);
        r.run();
        boolean[] blArray = isRunning;
        synchronized (isRunning) {
            isRunning[0] = false;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Thread.interrupted();
            return;
        }
    }
}

