/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.execution.ExecutionResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.VirtualMachine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockDebugProcess
extends DebugProcessEvents {
    private static final Logger LOG = Logger.getInstance(MockDebugProcess.class);
    private final MockVirtualMachine myVirtualMachine;
    private VirtualMachineProxyImpl myVirtualMachineProxy;

    public MockDebugProcess(Project project, MockVirtualMachine virtualMachine, Disposable disposable) {
        super(project);
        this.myVirtualMachine = virtualMachine;
        this.myState.set(DebugProcessImpl.State.ATTACHED);
        Disposer.register((Disposable)disposable, () -> {
            try {
                this.getManagerThread().close();
                while (!this.getManagerThread().getCurrentRequest().isDone()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.dispose();
            }
        });
    }

    @Nullable
    public ExecutionResult attachVirtualMachine(DebugEnvironment environment, DebuggerSession session) {
        this.mySession = session;
        return null;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        if (this.myVirtualMachineProxy == null) {
            this.myVirtualMachineProxy = new VirtualMachineProxyImpl((DebugProcessImpl)this, (VirtualMachine)this.myVirtualMachine);
        }
        return this.myVirtualMachineProxy;
    }
}

