/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.quickFix.ActionHint;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    private static QuickFixTestCase myWrapper;

    @Override
    protected void tearDown() throws Exception {
        myWrapper = null;
        super.tearDown();
    }

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    private static void doTestFor(@NotNull String testName2, @NotNull QuickFixTestCase quickFixTestCase) {
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/before" + testName2;
        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), () -> {
            try {
                String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)StandardCharsets.UTF_8));
                quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                quickFixTestCase.bringRealEditorBack();
                ActionHint actionHint = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                quickFixTestCase.beforeActionStarted(testName2, contents);
                try {
                    myWrapper = quickFixTestCase;
                    quickFixTestCase.doAction(actionHint, testFullPath, testName2);
                }
                finally {
                    myWrapper = null;
                    quickFixTestCase.afterActionCompleted(testName2, contents);
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError(testName2 + " failed", e);
            }
        }, "", (Object)"");
    }

    protected void afterActionCompleted(String testName2, String contents) {
    }

    protected void beforeActionStarted(String testName2, String contents) {
    }

    public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName2, @NotNull QuickFixTestCase quickFix) throws Exception {
        IntentionAction action2 = actionHint.findAndCheck(quickFix.getAvailableActions(), () -> this.getTestInfo(testFullPath, quickFix));
        if (action2 != null) {
            IntentionAction afterAction;
            String text = action2.getText();
            quickFix.invoke(action2);
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/after" + testName2;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
            String familyName = action2.getFamilyName();
            if (StringUtil.isEmptyOrSpaces((String)familyName)) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' provides empty family name which means that user would see action with empty presentable text in Inspection Results"));
            }
        }
    }

    private String getTestInfo(@NotNull String testFullPath, @NotNull QuickFixTestCase quickFix) {
        String infos = LightQuickFixTestCase.getCurrentHighlightingInfo(quickFix.doHighlighting());
        return "Test: " + testFullPath + "\nLanguage level: " + PsiUtil.getLanguageLevel((Project)quickFix.getProject()) + "\n" + (String)(quickFix.getProject().equals(this.getProject()) ? "SDK: " + ModuleRootManager.getInstance((Module)this.getModule()).getSdk() + "\n" : "") + "Infos: " + infos;
    }

    static String getCurrentHighlightingInfo(@NotNull List<HighlightInfo> infos) {
        return ((StreamEx)StreamEx.of(infos).filter(info -> info.getSeverity() != HighlightInfoType.SYMBOL_TYPE_SEVERITY)).map(info -> {
            String fixes = "";
            if (info.quickFixActionRanges != null) {
                fixes = StreamEx.of((Collection)info.quickFixActionRanges).map(p -> p.getSecond() + " " + p.getFirst()).mapLastOrElse("|- "::concat, "\\- "::concat).map(str -> "        " + str + "\n").joining();
            }
            return info.getSeverity() + ": (" + info.getStartOffset() + "," + info.getEndOffset() + ") '" + info.getText() + "': " + info.getDescription() + "\n" + fixes;
        }).joining((CharSequence)"       ");
    }

    protected void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName2) throws Exception {
        this.doAction(actionHint, testFullPath, testName2, myWrapper);
    }

    protected void doAction(@NotNull String actionName) {
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action2 = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + available), (Object)action2);
        this.invoke(action2);
    }

    protected void invoke(@NotNull IntentionAction action2) throws IncorrectOperationException {
        CodeInsightTestFixtureImpl.invokeIntention((IntentionAction)action2, (PsiFile)this.getFile(), (Editor)this.getEditor());
    }

    protected IntentionAction findActionAndCheck(@NotNull ActionHint hint, String testFullPath) {
        return hint.findAndCheck(this.getAvailableActions(), () -> "Test: " + testFullPath);
    }

    protected IntentionAction findActionWithText(@NotNull String text) {
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(@NotNull List<? extends IntentionAction> actions, @NotNull String text) {
        for (IntentionAction intentionAction : actions) {
            if (!text.equals(intentionAction.getText())) continue;
            return intentionAction;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    protected void doAllTests() {
        LightQuickFixTestCase.doAllTests(this.createWrapper());
    }

    public static void doAllTests(QuickFixTestCase testCase2) {
        File[] files;
        for (File file : files = LightQuickFixTestCase.getBeforeTestFiles(testCase2)) {
            String testName2 = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName2, testCase2);
        }
    }

    public static File @NotNull [] getBeforeTestFiles(@NotNull QuickFixTestCase testCase2) {
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase2.getBasePath());
        String testDirPath = testCase2.getTestDataPath().replace(File.separatorChar, '/') + testCase2.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles((dir, name) -> name.startsWith(BEFORE_PREFIX));
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        return files;
    }

    protected void doSingleTest(@NotNull String fileSuffix) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(String fileSuffix, String testDataPath) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    protected ActionHint parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
        return ActionHint.parse((PsiFile)file, (String)contents);
    }

    @NotNull
    protected QuickFixTestCase createWrapper() {
        return this.createWrapper(null);
    }

    @NotNull
    protected QuickFixTestCase createWrapper(final String testDataPath) {
        return new QuickFixTestCase(){
            String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            @NotNull
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                return this.myTestDataPath;
            }

            @Override
            @NotNull
            public ActionHint parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
                return LightQuickFixTestCase.this.parseActionHintImpl(file, contents);
            }

            @Override
            public void beforeActionStarted(@NotNull String testName2, @NotNull String contents) {
                LightQuickFixTestCase.this.beforeActionStarted(testName2, contents);
            }

            @Override
            public void afterActionCompleted(@NotNull String testName2, @NotNull String contents) {
                LightQuickFixTestCase.this.afterActionCompleted(testName2, contents);
            }

            @Override
            public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName2) throws Exception {
                LightQuickFixTestCase.this.doAction(actionHint, testFullPath, testName2);
            }

            @Override
            public void checkResultByFile(@NotNull String message, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
                LightQuickFixTestCase.this.checkResultByFile(message, expectedFilePath, ignoreTrailingSpaces);
            }

            @Override
            public IntentionAction findActionWithText(@NotNull String text) {
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(@NotNull IntentionAction action2) {
                LightQuickFixTestCase.this.invoke(action2);
            }

            @Override
            @NotNull
            public List<HighlightInfo> doHighlighting() {
                return LightQuickFixTestCase.this.doHighlighting();
            }

            @Override
            @NotNull
            public List<IntentionAction> getAvailableActions() {
                return LightQuickFixTestCase.this.getAvailableActions();
            }

            @Override
            public void configureFromFileText(@NotNull String name, @NotNull String contents) {
                LightQuickFixTestCase.this.configureFromFileText(name, contents, true);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.this.getFile();
            }

            @Override
            public Project getProject() {
                return LightQuickFixTestCase.this.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.this.bringRealEditorBack();
            }
        };
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(this.getEditor(), this.getFile());
    }

    @NotNull
    public static List<IntentionAction> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file) {
        return CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)editor, (PsiFile)file);
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }
}

