/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestClassesFilter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class GroupBasedTestClassFilter
extends TestClassesFilter {
    public static final String ALL_EXCLUDE_DEFINED = "ALL_EXCLUDE_DEFINED";
    private final Set<String> myGroupNames;
    private final boolean myMatchUnlisted;
    private final List<Group> myGroups;

    public GroupBasedTestClassFilter(MultiMap<String, String> filters, List<String> groupNames) {
        this.myGroupNames = new HashSet<String>(groupNames);
        this.myMatchUnlisted = this.myGroupNames.isEmpty() || this.myGroupNames.contains(ALL_EXCLUDE_DEFINED);
        this.myGroups = new ArrayList<Group>(filters.size());
        for (String groupName : filters.keySet()) {
            Collection groupFilters = filters.get((Object)groupName);
            List<Pattern> includePatterns = groupFilters.stream().filter(s -> !s.startsWith("-")).map(s -> TestClassesFilter.compilePattern(s)).collect(Collectors.toList());
            List<Pattern> excludedPatterns = groupFilters.stream().filter(s -> s.startsWith("-")).map(s -> TestClassesFilter.compilePattern(s.substring(1))).collect(Collectors.toList());
            this.myGroups.add(new Group(groupName, includePatterns, excludedPatterns));
        }
    }

    @NotNull
    public static TestClassesFilter createOn(@NotNull Reader reader, @NotNull List<String> testGroupNames) throws IOException {
        MultiMap groups = MultiMap.createLinked();
        GroupBasedTestClassFilter.readGroups(reader, (MultiMap<String, String>)groups);
        return new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
    }

    public static void readGroups(@NotNull Reader reader, @NotNull MultiMap<String, String> groupNameToPatternsMap) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String currentGroupName = "";
        while ((line = bufferedReader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                currentGroupName = line.substring(1, line.length() - 1);
                continue;
            }
            groupNameToPatternsMap.putValue((Object)currentGroupName, (Object)line);
        }
    }

    @Override
    public boolean matches(String className, String moduleName) {
        return this.myGroups.stream().filter(g -> this.myGroupNames.contains(g.name)).anyMatch(g -> g.matches(className)) || this.myMatchUnlisted && !ContainerUtil.exists(this.myGroups, g -> g.matches(className));
    }

    public String toString() {
        return "GroupBasedTestClassFilter{names=" + this.myGroupNames + "}";
    }

    private static final class Group {
        private final String name;
        private final List<Pattern> included;
        private final List<Pattern> excluded;

        private Group(String name, List<Pattern> included, List<Pattern> excluded) {
            this.name = name;
            this.excluded = excluded;
            this.included = included;
        }

        private boolean matches(String className) {
            return !TestClassesFilter.matchesAnyPattern(this.excluded, className) && TestClassesFilter.matchesAnyPattern(this.included, className);
        }
    }
}

