/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangExtensionService;
import org.jetbrains.jps.intellilang.model.impl.JpsIntelliLangConfigurationImpl;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;

public final class JpsIntelliLangConfigurationSerializer
extends JpsGlobalExtensionSerializer {
    private static final Logger LOG = Logger.getInstance(JpsIntelliLangConfigurationSerializer.class);
    private static final String INSTRUMENTATION_TYPE_NAME = "INSTRUMENTATION";
    private static final String PATTERN_ANNOTATION_NAME = "PATTERN_ANNOTATION";

    JpsIntelliLangConfigurationSerializer() {
        super("IntelliLang.xml", "LanguageInjectionConfiguration");
    }

    public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
        String instrumentationType;
        JpsIntelliLangConfigurationImpl configuration = new JpsIntelliLangConfigurationImpl();
        String annotationName = JDOMExternalizerUtil.readField((Element)componentTag, (String)PATTERN_ANNOTATION_NAME);
        if (annotationName != null) {
            configuration.setPatternAnnotationClassName(annotationName);
        }
        if ((instrumentationType = JDOMExternalizerUtil.readField((Element)componentTag, (String)INSTRUMENTATION_TYPE_NAME)) != null) {
            try {
                configuration.setInstrumentationType(InstrumentationType.valueOf(instrumentationType));
            }
            catch (IllegalArgumentException e) {
                LOG.info((Throwable)e);
            }
        }
        JpsIntelliLangExtensionService.getInstance().setConfiguration(global, configuration);
    }

    public void loadExtensionWithDefaultSettings(@NotNull JpsGlobal global) {
        JpsIntelliLangExtensionService.getInstance().setConfiguration(global, new JpsIntelliLangConfigurationImpl());
    }
}

