/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.tagexpression;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.internal.impldep.org.junit.platform.launcher.tagexpression.Operator;
import org.gradle.internal.impldep.org.junit.platform.launcher.tagexpression.TagExpressions;

class Operators {
    private static final Operator Not = Operator.unaryOperator("!", 3, Operator.Associativity.Right, TagExpressions::not);
    private static final Operator And = Operator.binaryOperator("&", 2, Operator.Associativity.Left, TagExpressions::and);
    private static final Operator Or = Operator.binaryOperator("|", 1, Operator.Associativity.Left, TagExpressions::or);
    private final Map<String, Operator> representationToOperator = Stream.of(Not, And, Or).collect(Collectors.toMap(Operator::representation, Function.identity()));

    Operators() {
    }

    boolean isOperator(String token) {
        return this.representationToOperator.containsKey(token);
    }

    Operator operatorFor(String token) {
        return this.representationToOperator.get(token);
    }
}

