/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructTypeAnnotationAttribute
extends StructGeneralAttribute {
    private List<TypeAnnotation> annotations = Collections.emptyList();

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.annotations = new ArrayList<TypeAnnotation>(len);
            for (int i = 0; i < len; ++i) {
                this.annotations.add(StructTypeAnnotationAttribute.parse(data, pool));
            }
        } else {
            this.annotations = Collections.emptyList();
        }
    }

    private static TypeAnnotation parse(DataInputStream data, ConstantPool pool) throws IOException {
        int i;
        TargetInfo targetInfo;
        int targetType = data.readUnsignedByte();
        switch (targetType) {
            case 0: 
            case 1: {
                targetInfo = new TargetInfo.TypeParameterTarget(data.readUnsignedByte());
                break;
            }
            case 16: {
                targetInfo = new TargetInfo.SupertypeTarget(data.readUnsignedShort());
                break;
            }
            case 17: 
            case 18: {
                targetInfo = new TargetInfo.TypeParameterBoundTarget(data.readUnsignedByte(), data.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                targetInfo = new TargetInfo.EmptyTarget();
                break;
            }
            case 22: {
                targetInfo = new TargetInfo.FormalParameterTarget(data.readUnsignedByte());
                break;
            }
            case 23: {
                targetInfo = new TargetInfo.ThrowsTarget(data.readUnsignedShort());
                break;
            }
            case 64: 
            case 65: {
                int tableLength = data.readUnsignedShort();
                TargetInfo.LocalvarTarget.Offsets[] offsets = new TargetInfo.LocalvarTarget.Offsets[tableLength];
                for (i = 0; i < tableLength; ++i) {
                    offsets[i] = new TargetInfo.LocalvarTarget.Offsets(data.readUnsignedShort(), data.readUnsignedShort(), data.readUnsignedShort());
                }
                targetInfo = new TargetInfo.LocalvarTarget(offsets);
                break;
            }
            case 66: {
                targetInfo = new TargetInfo.CatchTarget(data.readUnsignedShort());
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                targetInfo = new TargetInfo.OffsetTarget(data.readUnsignedShort());
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                targetInfo = new TargetInfo.TypeArgumentTarget(data.readUnsignedShort(), data.readUnsignedByte());
                break;
            }
            default: {
                throw new RuntimeException("unknown target type: " + targetType);
            }
        }
        int pathLength = data.readUnsignedByte();
        ArrayList<StructTypePathEntry> paths = new ArrayList<StructTypePathEntry>(pathLength);
        for (i = 0; i < pathLength; ++i) {
            paths.add(i, new StructTypePathEntry(data.readUnsignedByte(), data.readUnsignedByte()));
        }
        AnnotationExprent annotation = StructAnnotationAttribute.parseAnnotation(data, pool);
        return new TypeAnnotation(targetType, targetInfo, paths, annotation);
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }
}

